/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import azcheck.ui.JSpellDialog;
import azcheck.ui.JTextAutoSpellCheck;
import com.appframework.SCMouseListener;
import com.appframework.components.htmleditor.GwRTFEditorKit;
import com.appframework.components.htmleditor.HTMLConstants;
import com.appframework.components.htmleditor.HTMLStyledEditorKit;
import com.appframework.components.htmleditor.InputAttributesChangeListener;
import com.appframework.components.htmleditor.InvalidTextException;
import com.appframework.components.htmleditor.hyperlink.HTMLUtils;
import com.appframework.components.htmleditor.hyperlink.Link;
import com.appframework.components.htmleditor.hyperlink.LinkFinder;
import com.appframework.components.htmleditor.ui.BasicTextPaneUI_CLONE;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.account.AccountSettings;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.engine.MachineSettings;
import com.novell.gw.jclient.application.controls.ColorUtils;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.ScrollPaneBorderHighlightFocusListener;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextPane;
import com.novell.gw.jclient.application.controls.textcomponent.EditableDocumentListener;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.BitSet;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TextAction;
import javax.swing.text.Utilities;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import org.apache.log4j.Logger;

public abstract class HTMLTextPane
extends OrientableTextPane {
    private static Logger logger = Logger.getLogger(HTMLTextPane.class);
    private static AffineTransform NORMALIZED_TRANSFORM = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getNormalizingTransform();
    public static final String LINK_ATTR = "hyperlink";
    public static final String DELETE_NEXT_WORD_ACTION = "delete-next-word";
    public static final String DELETE_PREV_WORD_ACTION = "delete-prev-word";
    protected int mode = -1;
    private EditableDocumentListener editableDocumentListener;
    private LinkRecognizerDocumentListener linkRecognizerDocumentListener = new LinkRecognizerDocumentListener();
    private UndoableEditListener undoableEditListener;
    private SCMouseListener spellCheckListener = new SCMouseListener();
    private EventListenerList listeners;
    private boolean ignoreDefaultFontAttributes = false;
    private boolean isTextChangedByUser = false;

    public void setSelectionColor(Color c) {
        super.setSelectionColor(ColorUtils.unwrapColor(c));
    }

    public void setSelectedTextColor(Color c) {
        super.setSelectedTextColor(ColorUtils.unwrapColor(c));
    }

    public HTMLTextPane() {
        this.setUI(new BasicTextPaneUI_CLONE());
        this.setFocusable(true);
        this.getInputMap().put(KeyStroke.getKeyStroke(9, 1), "goToPrevComponent");
        this.getActionMap().put("goToPrevComponent", new AbstractAction("goToPrevComponent"){

            public void actionPerformed(ActionEvent e) {
                Component next = HTMLTextPane.this.getFocusTraversalPolicy().getComponentBefore(ControlsUtils.getWindowForComponent(HTMLTextPane.this), HTMLTextPane.this);
                next.requestFocus();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(9, 0), "goToNextComponent");
        this.getActionMap().put("goToNextComponent", new AbstractAction("goToNextComponent"){

            public void actionPerformed(ActionEvent e) {
                Component next = HTMLTextPane.this.getFocusTraversalPolicy().getComponentAfter(ControlsUtils.getWindowForComponent(HTMLTextPane.this), HTMLTextPane.this);
                next.requestFocus();
            }
        });
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.addFocusListener(new ScrollPaneBorderHighlightFocusListener(this));
        this.setDragEnabled(true);
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                HTMLTextPane.this.setTextChangedByUser(true);
            }
        });
        this.listeners = new EventListenerList();
    }

    public void addInputAttributesChangeListener(InputAttributesChangeListener listener) {
        this.listeners.add(InputAttributesChangeListener.class, listener);
    }

    public void removeInputAttributesChangeListener(InputAttributesChangeListener listener) {
        this.listeners.remove(InputAttributesChangeListener.class, listener);
    }

    public void addInputAttributes(AttributeSet attibutes) {
        if (attibutes != null) {
            MutableAttributeSet inputAttributes = this.getInputAttributes();
            inputAttributes.addAttributes(attibutes);
            this.fireInputAttributesChanged();
        }
    }

    private void fireInputAttributesChanged() {
        ChangeEvent event = new ChangeEvent(this);
        for (InputAttributesChangeListener listener : (InputAttributesChangeListener[])this.listeners.getListeners(InputAttributesChangeListener.class)) {
            listener.stateChanged(event);
        }
    }

    public String getName() {
        return "HTMLTextPane";
    }

    public String getSelectedText() {
        String selectedText = super.getSelectedText();
        if (selectedText != null) {
            selectedText = selectedText.replaceAll("\u00a0", " ");
        }
        return selectedText;
    }

    public boolean isTextChangedByUser() {
        return this.isTextChangedByUser;
    }

    public void setTextChangedByUser(boolean isTextChangedByUser) {
        this.isTextChangedByUser = isTextChangedByUser;
    }

    public URL getPage() {
        return null;
    }

    protected EditorKit createEditorKit(int theMode) {
        StyledEditorKit kit = null;
        if (theMode == 1) {
            kit = new HTMLStyledEditorKit(this.isEditable());
        } else if (theMode == 2 || theMode == 3) {
            kit = new GwRTFEditorKit(theMode);
        }
        if (this.isEditable()) {
            this.getInputMap().put(KeyStroke.getKeyStroke(8, 128), DELETE_PREV_WORD_ACTION);
            this.getActionMap().put(DELETE_PREV_WORD_ACTION, new DeletePrevWordAction());
            this.getInputMap().put(KeyStroke.getKeyStroke(127, 128), DELETE_NEXT_WORD_ACTION);
            this.getActionMap().put(DELETE_NEXT_WORD_ACTION, new DeleteNextWordAction());
            this.getInputMap().put(KeyStroke.getKeyStroke(8, 64), "delete-previous");
        }
        return kit;
    }

    public int getMode() {
        return this.mode;
    }

    public String getDefaultFontName() {
        return HTMLConstants.getDefaultFontName(this.mode, this.isEditable());
    }

    public int getDefaultFontSize() {
        return HTMLConstants.getDefaultFontSize(this.mode, this.isEditable());
    }

    public void setDefaultFont(String theFontName, int theFontSize) {
        HTMLUtils.setDefaultFont(this, theFontName, theFontSize);
    }

    public void setDefaultFont() {
        this.setDefaultFont(this.getDefaultFontName(), this.getDefaultFontSize());
    }

    public synchronized void setMode(int theMode) {
        if (this.mode != theMode) {
            this.mode = theMode;
            this.unregisterListeners(this.getDocument());
            this.setEditorKit(this.createEditorKit(theMode));
            if (this.isEditable()) {
                this.setDefaultFont();
            }
            this.registerListeners(this.getDocument());
        }
    }

    public void applyHTMLParagraphAttributes() {
        StyledDocument doc = (StyledDocument)this.getDocument();
        SimpleAttributeSet attr = new SimpleAttributeSet();
        doc.setParagraphAttributes(0, this.getDocument().getLength(), attr, false);
    }

    public void setCaretPosition(int position) {
        int pos = position;
        if (position > this.getDocument().getLength() || position < 0) {
            pos = this.getDocument().getLength();
        }
        super.setCaretPosition(pos);
    }

    private static int getStartPosition(Element theRoot) {
        HTML.Tag name = HTMLUtils.getNameAttribute(theRoot);
        if (name == HTML.Tag.BODY) {
            return theRoot.getStartOffset();
        }
        for (int i = 0; i < theRoot.getElementCount(); ++i) {
            Element element = theRoot.getElement(i);
            int result = HTMLTextPane.getStartPosition(element);
            if (result == -1) continue;
            return result;
        }
        return -1;
    }

    public void setEditableDocumentListener(EditableDocumentListener theEditableDocumentListener) {
        this.editableDocumentListener = theEditableDocumentListener;
    }

    public void setUndoableListener(UndoableEditListener theUndoableEditListener) {
        this.undoableEditListener = theUndoableEditListener;
    }

    public void clear() {
        try {
            this.putClientProperty("charset", "utf-8");
            this.getDocument().remove(0, this.getDocument().getLength());
        }
        catch (BadLocationException e) {
            logger.error((Object)e);
        }
    }

    public void setWebPage(URL page) throws IOException {
        this.clear();
        super.setPage(page);
    }

    public void setPage(URL page) throws IOException {
        HTMLUtils.removeEscapeChars(page);
        this.clear();
        super.setPage(page);
    }

    public void setDocument(Document doc) {
        this.unregisterListeners(this.getDocument());
        super.setDocument(doc);
    }

    public String getStyledText() {
        return HTMLUtils.getStyledText(this);
    }

    public String getPlainText() {
        return HTMLUtils.getPlainText(this);
    }

    private String normalizeText(String theText) {
        int mode = this.mode;
        if (mode == 2 || mode == 3) {
            theText = theText.replaceAll("\\\\line", "\\\\par");
            theText = HTMLTextPane.recognizeRtfLinks(theText);
            theText = HTMLTextPane.removeBrokenHyphenRTF(theText);
            return this.replaceFonts(theText);
        }
        return theText;
    }

    private static String removeBrokenHyphenRTF(String theText) {
        Pattern pattern = Pattern.compile("((\\\\)*)\\\\_");
        Matcher matcher = pattern.matcher(theText);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String s = matcher.group(1);
            if (s.length() % 4 != 0) continue;
            matcher.appendReplacement(sb, s + "-");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String replaceFonts(String theText) {
        StringBuffer result = new StringBuffer(theText);
        String STYLE_SHEET = "{\\stylesheet{\\fs";
        String GROUP_WISEVIEW = "GroupWiseView;}";
        int defFontIndex = result.indexOf("{\\stylesheet{\\fs");
        Integer defFontOptionSize = HTMLConstants.getDefaultFontSizeFromOptions(this.getMode());
        if (defFontIndex != -1 && defFontOptionSize != null && defFontOptionSize > 0) {
            int defFontSize = this.getDefaultFontSize();
            int endIndex = result.indexOf("GroupWiseView;}");
            Integer integer = HTMLTextPane.getInteger(defFontIndex + "{\\stylesheet{\\fs".length(), result.toString());
            if (integer == null) {
                return result.toString();
            }
            int composeFontSize = integer / 2;
            int index = endIndex;
            while ((index = result.indexOf("\\fs", index)) != -1) {
                if (result.charAt(index - 1) != '\\') {
                    integer = HTMLTextPane.getInteger(index += 3, result.toString());
                    if (integer == null) continue;
                    int oldFontSize = integer / 2;
                    int fontSize = Math.round((float)defFontSize * ((float)oldFontSize / (float)composeFontSize)) * 2;
                    result.replace(index, index + integer.toString().length(), Integer.toString(fontSize));
                    continue;
                }
                index += 3;
            }
        }
        return result.toString();
    }

    private static Integer getInteger(int startIndex, String text) {
        int digitLength = 0;
        while (Character.isDigit(text.charAt(startIndex + digitLength))) {
            ++digitLength;
        }
        if (digitLength != 0) {
            return Integer.valueOf(text.substring(startIndex, startIndex + digitLength));
        }
        return null;
    }

    private static String recognizeRtfLinks(String theText) {
        try {
            int fldinst = -1;
            while ((fldinst = theText.indexOf("{\\*\\fldinst", fldinst + 1)) > 0) {
                int fromIndex;
                int textpos;
                int fldrsltEnd;
                int fldrslt;
                Matcher m;
                int hyperlink = theText.indexOf("HYPERLINK", fldinst);
                int fldinstEnd = theText.indexOf(125, fldinst);
                if (hyperlink <= 0 || hyperlink >= fldinstEnd || !(m = HTMLUtils.PATTERN_HYPERLINK.matcher(theText.substring(hyperlink))).find()) continue;
                String url = m.group(0);
                int index = url.indexOf(34);
                if (index != -1) {
                    url = url.substring(0, index);
                }
                if ((fldrslt = theText.indexOf("{\\fldrslt", hyperlink)) <= 0 || (fldrsltEnd = theText.indexOf(125, fldrslt)) <= 0 || (textpos = theText.indexOf(32, fromIndex = theText.lastIndexOf(92, fldrsltEnd))) <= 0 || textpos > fldrsltEnd) continue;
                String text = theText.substring(textpos + 1, fldrsltEnd);
                if (!text.equals(url)) {
                    text = text + " <" + url + '>';
                }
                int field = theText.lastIndexOf("{\\field", fldinst);
                int end = theText.indexOf(125, theText.indexOf(125, fldrsltEnd + 1) + 1);
                if (field <= 0 || end <= field) continue;
                theText = theText.substring(0, field) + ' ' + text + theText.substring(end + 1);
            }
        }
        catch (Exception e) {
            logger.debug((Object)e, (Throwable)e);
        }
        return theText;
    }

    private void forceDefaultFontAttributes() {
        MachineSettings.TextOption textOption;
        String fontName;
        if (this.mode != 1 && !this.isEditable() && (fontName = (textOption = OptionManager.getInstance().getTextOption()).getDefaultReadPlainTextFont()) != null && fontName.trim().length() != 0) {
            Font newFont = new Font(this.getDefaultFontName(), 0, this.getDefaultFontSize());
            if (this.mode == 2 || this.mode == 3) {
                StyledDocument sdoc = this.getStyledDocument();
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setFontFamily(attr, newFont.getFamily());
                sdoc.setCharacterAttributes(0, sdoc.getLength(), attr, false);
                ((StyledEditorKit)this.getEditorKit()).getInputAttributes().addAttributes(attr);
            }
        }
    }

    public void setRTFTextFont(Font theFont) {
        if (this.mode == 2 || this.mode == 3) {
            StyledDocument sdoc = this.getStyledDocument();
            SimpleAttributeSet attr = new SimpleAttributeSet();
            StyleConstants.setFontSize(attr, theFont.getSize());
            StyleConstants.setFontFamily(attr, theFont.getFamily());
            StyleConstants.setItalic(attr, theFont.isItalic());
            StyleConstants.setBold(attr, theFont.isBold());
            StyleConstants.setUnderline(attr, theFont.isTransformed());
            sdoc.setCharacterAttributes(0, sdoc.getLength(), attr, false);
            ((StyledEditorKit)this.getEditorKit()).getInputAttributes().addAttributes(attr);
        }
    }

    public void setStyledText(String theStyledText) {
        int currentPos;
        if (this.mode != 1 && this.mode != 2 && this.mode != 3) {
            throw new InvalidParameterException("Incorrect mode. Expecting modes: [1, 2] Current mode: [" + this.mode + ']');
        }
        Document doc = this.getDocument();
        this.unregisterListeners(doc);
        try {
            super.setText(this.normalizeText(theStyledText));
        }
        catch (Exception e) {
            throw new InvalidTextException(e);
        }
        if (!this.ignoreDefaultFontAttributes) {
            this.forceDefaultFontAttributes();
        }
        if ((currentPos = HTMLTextPane.getStartPosition(this.getDocument().getDefaultRootElement())) > 0) {
            try {
                this.getDocument().remove(0, currentPos);
                currentPos = 0;
            }
            catch (BadLocationException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        if (this.isEditable()) {
            this.setDefaultFont();
        }
        if (this.mode == 2 || this.mode == 3) {
            this.insertLinks();
        }
        this.setCaretPosition(currentPos);
        this.registerListeners(this.getDocument());
        if (this.mode == 3) {
            boolean cursurBottom = false;
            AccountSettings accountSettings = EngineCommandManager.getAccountSettings();
            AccountSettings.PlainTextReplyFormat plainTextReplyFormat = accountSettings.getPlainTextReplyFormat();
            if (plainTextReplyFormat.getReplyType() != 0 && plainTextReplyFormat.isReplyInsertAtBottom()) {
                cursurBottom = true;
            }
            SimpleAttributeSet attributeSet = new SimpleAttributeSet();
            attributeSet.addAttribute(StyleConstants.FontSize, new Integer(this.getDefaultFontSize()));
            attributeSet.addAttribute(StyleConstants.FontFamily, this.getDefaultFontName());
            if (!cursurBottom) {
                ((StyledDocument)this.getDocument()).setCharacterAttributes(0, 1, attributeSet, true);
            } else {
                ((StyledDocument)this.getDocument()).setCharacterAttributes(this.getDocument().getLength(), this.getDocument().getLength(), attributeSet, true);
            }
        }
    }

    public void setPlainText(String thePlainText) {
        if (this.mode == 1) {
            this.setStyledText(UIUtils.wrapIntoHTML(thePlainText));
        } else if (this.mode == 2 || this.mode == 3) {
            this.setStyledText(UIUtils.wrapIntoRTF(thePlainText));
            this.insertLinks();
        } else {
            throw new InvalidParameterException("Incorrect mode. Expecting modes: [1, 2] Current mode: [" + this.mode + ']');
        }
        this.setCaretPosition(0);
    }

    public void insertLinks() {
        String source = this.getPlainText();
        int x = -1;
        source = HTMLTextPane.removeBrokenHyphen(source);
        Matcher m = HTMLUtils.PATTERN_HYPERLINK.matcher(source);
        while (m.find()) {
            String link = m.group(0);
            char lastChar = link.charAt(link.length() - 1);
            if (lastChar == '.' || lastChar == ',') {
                link = link.substring(0, link.length() - 1);
            }
            x = source.indexOf(link, x + 1);
            this.insertLink(link, x);
        }
    }

    private static String removeBrokenHyphen(String link) {
        int brokenHyphen = 8209;
        while (link.indexOf(8209) != -1) {
            link = link.replace('\u2011', '-');
        }
        return link;
    }

    private void insertLink(String URL2, int pos) {
        Document document = this.getDocument();
        Style style = this.addStyle(URL2, StyleContext.getDefaultStyleContext().getStyle("default"));
        if (document instanceof DefaultStyledDocument) {
            style.addAttributes(((DefaultStyledDocument)document).getCharacterElement(pos).getAttributes());
        }
        StyleConstants.setItalic(style, true);
        StyleConstants.setUnderline(style, true);
        if (style.getAttribute("foreground") == null) {
            StyleConstants.setForeground(style, Color.BLUE);
        }
        style.addAttribute(LINK_ATTR, URL2);
        try {
            document.remove(pos, URL2.length());
            document.insertString(pos, URL2, style);
        }
        catch (BadLocationException e) {
            logger.error((Object)e);
        }
    }

    private void registerListeners(Document theDoc) {
        theDoc.addDocumentListener(this.editableDocumentListener);
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        boolean spellCheck = (Boolean)dataStoreSettings.getCheckSpellingAsYouType().getValue();
        if (spellCheck && this.isEditable()) {
            try {
                JSpellDialog.enableAutoCheck((JTextComponent)this, (String)OS.getDictLanguage());
            }
            catch (Exception e) {
                try {
                    JSpellDialog.enableAutoCheck((JTextComponent)this, (String)String.format("%s-%s", Locale.US.getLanguage(), Locale.US.getCountry()));
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                    logger.debug((Object)e1, (Throwable)e1);
                }
            }
        }
        this.addMouseListener(this.spellCheckListener);
        theDoc.addDocumentListener(this.linkRecognizerDocumentListener);
        theDoc.addUndoableEditListener(this.undoableEditListener);
    }

    private void unregisterListeners(Document theDoc) {
        if (theDoc == null) {
            return;
        }
        theDoc.removeDocumentListener(this.editableDocumentListener);
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        boolean spellCheck = (Boolean)dataStoreSettings.getCheckSpellingAsYouType().getValue();
        if (spellCheck && this.isEditable()) {
            JTextAutoSpellCheck.stopChecking((JTextComponent)this);
            this.removeMouseListener(this.spellCheckListener);
        }
        theDoc.removeDocumentListener(this.linkRecognizerDocumentListener);
        theDoc.removeUndoableEditListener(this.undoableEditListener);
    }

    public boolean isIgnoreDefaultFontAttributes() {
        return this.ignoreDefaultFontAttributes;
    }

    public void setIgnoreDefaultFontAttributes(boolean ignoreDefaultFontAttributes) {
        this.ignoreDefaultFontAttributes = ignoreDefaultFontAttributes;
    }

    protected Font increaseFontSize(Font font) {
        if (font.isTransformed() && font.getTransform().equals(NORMALIZED_TRANSFORM)) {
            return font;
        }
        return font.deriveFont(NORMALIZED_TRANSFORM);
    }

    private static class DeletePrevWordAction
    extends TextAction {
        public DeletePrevWordAction() {
            super(HTMLTextPane.DELETE_PREV_WORD_ACTION);
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target != null) {
                int offs = target.getCaretPosition();
                boolean failed = false;
                try {
                    Element curPara = Utilities.getParagraphElement(target, offs);
                    offs = Utilities.getPreviousWord(target, offs);
                    if (offs < curPara.getStartOffset()) {
                        offs = Utilities.getParagraphElement(target, offs).getEndOffset() - 1;
                    }
                }
                catch (BadLocationException bl) {
                    if (offs != 0) {
                        offs = 0;
                    }
                    failed = true;
                }
                if (!failed) {
                    try {
                        target.getDocument().remove(offs, target.getCaretPosition() - offs);
                    }
                    catch (BadLocationException e1) {
                        logger.error((Object)e1);
                        logger.debug((Object)e1, (Throwable)e1);
                    }
                } else {
                    UIManager.getLookAndFeel().provideErrorFeedback(target);
                }
            }
        }
    }

    private static class DeleteNextWordAction
    extends TextAction {
        public DeleteNextWordAction() {
            super(HTMLTextPane.DELETE_NEXT_WORD_ACTION);
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target != null) {
                int offs = target.getCaretPosition();
                boolean failed = false;
                int oldOffs = offs;
                Element curPara = Utilities.getParagraphElement(target, offs);
                try {
                    offs = Utilities.getNextWord(target, offs);
                    if (offs >= curPara.getEndOffset() && oldOffs != curPara.getEndOffset() - 1) {
                        offs = curPara.getEndOffset() - 1;
                    }
                }
                catch (BadLocationException bl) {
                    int end = target.getDocument().getLength();
                    if (offs != end) {
                        offs = oldOffs != curPara.getEndOffset() - 1 ? curPara.getEndOffset() - 1 : end;
                    }
                    failed = true;
                }
                if (!failed) {
                    try {
                        target.getDocument().remove(target.getCaretPosition(), offs - target.getCaretPosition());
                    }
                    catch (BadLocationException e1) {
                        logger.error((Object)e1);
                        logger.debug((Object)e1, (Throwable)e1);
                    }
                } else {
                    UIManager.getLookAndFeel().provideErrorFeedback(target);
                }
            }
        }
    }

    private class LinkRecognizerDocumentListener
    implements DocumentListener {
        private LinkRecognizerDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            Document document = HTMLTextPane.this.getDocument();
            if (document instanceof DefaultStyledDocument) {
                DefaultStyledDocument styledDocument = (DefaultStyledDocument)document;
                int offset = e.getOffset();
                int length = e.getLength();
                String newText = "";
                try {
                    newText = styledDocument.getText(offset, length);
                }
                catch (BadLocationException e1) {
                    logger.error((Object)e1, (Throwable)e1);
                }
                if (newText.length() == 1 && this.isDivider(newText)) {
                    this.replaceIfLink(styledDocument, offset, false, offset);
                    return;
                }
                this.checkContainsLink(styledDocument, newText, offset);
                AttributeSet attributes = styledDocument.getCharacterElement(offset).getAttributes();
                if (attributes.isDefined(HTML.Tag.A)) {
                    int endOffset = this.getEndDividerOffset(styledDocument, offset);
                    this.replaceIfLink(styledDocument, endOffset, true, offset + newText.length());
                }
            }
        }

        public void checkContainsLink(DefaultStyledDocument styledDocument, String newText, int insertOffset) {
            int beginOffset = 0;
            int offset = 0;
            int nLength = newText.length();
            while (true) {
                if (offset < nLength && !this.isDivider(newText.substring(offset, offset + 1))) {
                    ++offset;
                    continue;
                }
                if (this.isLink(newText.substring(beginOffset, offset))) {
                    this.replaceIfLink(styledDocument, insertOffset + offset, true, insertOffset + offset);
                }
                beginOffset = ++offset;
                if (offset >= nLength) break;
            }
        }

        public void removeUpdate(DocumentEvent e) {
            Document document = HTMLTextPane.this.getDocument();
            if (document instanceof DefaultStyledDocument) {
                DefaultStyledDocument styledDocument = (DefaultStyledDocument)document;
                int offset = e.getOffset();
                AttributeSet attributes = styledDocument.getCharacterElement(offset).getAttributes();
                if (attributes.isDefined(HTML.Tag.A)) {
                    int endOffset = this.getEndDividerOffset(styledDocument, offset);
                    this.replaceIfLink(styledDocument, endOffset, true, offset);
                    return;
                }
                int lastLinkCharOffset = offset - 1;
                attributes = styledDocument.getCharacterElement(lastLinkCharOffset).getAttributes();
                if (attributes.isDefined(HTML.Tag.A)) {
                    int endOffset = this.getEndDividerOffset(styledDocument, offset);
                    this.replaceIfLink(styledDocument, endOffset, true, offset);
                }
            }
        }

        private int getBeginDividerOffset(DefaultStyledDocument theStyledDocument, int theOffset) {
            String text = "";
            int offset = theOffset;
            while (!this.isDivider(text)) {
                --offset;
                try {
                    text = theStyledDocument.getText(offset, 1);
                }
                catch (BadLocationException e) {
                    // empty catch block
                    break;
                }
            }
            int endDividerOffset = this.getEndDividerOffset(theStyledDocument, ++offset);
            do {
                try {
                    text = theStyledDocument.getText(offset, endDividerOffset - offset);
                }
                catch (BadLocationException e) {
                    break;
                }
                ++offset;
            } while (!this.isLink(text));
            return --offset;
        }

        private int getEndDividerOffset(DefaultStyledDocument theStyledDocument, int theOffset) {
            String text = "";
            int offset = theOffset - 1;
            do {
                ++offset;
                try {
                    text = theStyledDocument.getText(offset, 1);
                }
                catch (BadLocationException e1) {
                    break;
                }
            } while (!this.isDivider(text));
            return offset;
        }

        private boolean isDivider(String theNewText) {
            char theChar;
            BitSet notURLDivider = ControlsUtils.getNotURLDivider();
            return theNewText.length() == 1 && (theChar = theNewText.charAt(0)) <= '\u0100' && !notURLDivider.get(theChar);
        }

        private void replaceIfLink(DefaultStyledDocument theStyledDocument, int endOffset, boolean insert, int caretOffset) {
            int beginOffset = this.getBeginDividerOffset(theStyledDocument, endOffset);
            try {
                String linkStr = theStyledDocument.getText(beginOffset, endOffset - beginOffset);
                if (this.isLink(linkStr)) {
                    Link link = LinkFinder.getLinkForString(linkStr);
                    SimpleAttributeSet htmlAttribs = new SimpleAttributeSet();
                    htmlAttribs.addAttribute("href", link.getNameWithProtocol());
                    SimpleAttributeSet insertedTagAttributes = new SimpleAttributeSet();
                    insertedTagAttributes.addAttribute(HTML.Tag.A, htmlAttribs);
                    insertedTagAttributes.addAttribute(StyleConstants.Foreground, Color.BLUE);
                    insertedTagAttributes.addAttribute(StyleConstants.Italic, Boolean.TRUE);
                    insertedTagAttributes.addAttribute(StyleConstants.Underline, Boolean.TRUE);
                    SwingUtilities.invokeLater(new InsertLinkThread(insertedTagAttributes, beginOffset, endOffset, theStyledDocument, insert, caretOffset));
                } else {
                    AttributeSet attributesBefore = theStyledDocument.getCharacterElement(endOffset).getAttributes();
                    if (attributesBefore.isDefined(HTML.Tag.A)) {
                        SwingUtilities.invokeLater(new InsertLinkThread(new SimpleAttributeSet(), beginOffset, endOffset, theStyledDocument, insert, caretOffset));
                    }
                }
            }
            catch (BadLocationException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }

        private boolean isLink(String linkStr) {
            return HTMLUtils.isMailLink(linkStr) || linkStr.indexOf("www.") == 0 || linkStr.indexOf("ftp.") == 0 || linkStr.indexOf("mailto:") == 0 || linkStr.indexOf("https://") == 0 || linkStr.indexOf("http://") == 0 || linkStr.indexOf("ftp://") == 0 || linkStr.indexOf("news://") == 0 || linkStr.indexOf("gopher://") == 0 || linkStr.indexOf("wais://") == 0;
        }

        public void changedUpdate(DocumentEvent e) {
        }

        private class InsertLinkThread
        implements Runnable {
            private int beginOffset;
            private int endOffset;
            private DefaultStyledDocument styledDocument;
            private SimpleAttributeSet tagAttributes;
            private boolean insert;
            private int caretOffset;

            public InsertLinkThread(SimpleAttributeSet theTagAttributes, int beginOffset, int endOffset, DefaultStyledDocument document, boolean insert, int caretOffset) {
                this.tagAttributes = theTagAttributes;
                this.beginOffset = beginOffset;
                this.endOffset = endOffset;
                this.styledDocument = document;
                this.insert = insert;
                this.caretOffset = caretOffset;
            }

            public void run() {
                AttributeSet linkAttr = this.styledDocument.getCharacterElement(this.beginOffset).getAttributes();
                SimpleAttributeSet notLinkAttr = new SimpleAttributeSet(linkAttr);
                if (HTMLTextPane.this.mode == 1) {
                    notLinkAttr.removeAttribute(CSS.Attribute.FONT_STYLE);
                    notLinkAttr.removeAttribute(CSS.Attribute.TEXT_DECORATION);
                    notLinkAttr.removeAttribute(CSS.Attribute.COLOR);
                    notLinkAttr.removeAttribute(HTML.Tag.A);
                } else {
                    StyleConstants.setItalic(notLinkAttr, false);
                    StyleConstants.setUnderline(notLinkAttr, false);
                    StyleConstants.setForeground(notLinkAttr, Color.BLACK);
                }
                int backUpSelectionStart = HTMLTextPane.this.getSelectionStart();
                int backUpSelectionEnd = HTMLTextPane.this.getSelectionEnd();
                HTMLTextPane.this.setSelectionStart(this.beginOffset);
                HTMLTextPane.this.setSelectionEnd(this.endOffset);
                HTMLTextPane.this.setCharacterAttributes(this.tagAttributes, false);
                if (!this.insert) {
                    HTMLTextPane.this.setSelectionStart(this.endOffset);
                    HTMLTextPane.this.setSelectionEnd(this.endOffset + 1);
                    HTMLTextPane.this.setCharacterAttributes(notLinkAttr, true);
                    HTMLTextPane.this.setSelectionStart(this.endOffset + 1);
                    HTMLTextPane.this.setSelectionEnd(this.endOffset + 1);
                    HTMLTextPane.this.setCharacterAttributes(notLinkAttr, true);
                } else {
                    HTMLTextPane.this.setSelectionStart(this.caretOffset);
                    HTMLTextPane.this.setSelectionEnd(this.caretOffset);
                }
                HTMLTextPane.this.setSelectionStart(backUpSelectionStart);
                HTMLTextPane.this.setSelectionEnd(backUpSelectionEnd);
            }
        }
    }
}

