/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.ActionEnablerTextField;
import com.novell.gw.jclient.application.controls.BasicDialog;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InsertLinkDialog
extends BasicDialog {
    private JTextField tfLinkText;
    private JTextField tfLinkHref;
    private JButton btnOk = new OrientableButton(new BtnOKAction());
    private JButton btnCancel = new OrientableButton(new BtnCancelAction());
    private boolean isActionCompletedSuccesevely = false;
    public static int MAILTO = 0;
    private boolean isMailto = false;

    public InsertLinkDialog(JFrame theFrame, boolean status) {
        super(theFrame);
        this.setModal(status);
        this.buildUI();
    }

    public InsertLinkDialog(JFrame theFrame, boolean status, int type) {
        super(theFrame);
        this.setModal(status);
        if (type == MAILTO) {
            this.isMailto = true;
        }
        this.buildUI();
    }

    private void buildUI() {
        if (this.isMailto) {
            this.setTitle(StringResources.MAIL_PROPERTIES);
        } else {
            this.setTitle(StringResources.HYPERLINK_PROPERTIES);
        }
        this.getContentPane().setLayout(new BorderLayout());
        OrientablePanel pnl = new OrientablePanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(15, 10, 5, 15);
        c.anchor = 21;
        c.fill = 0;
        c.weightx = 1.0;
        pnl.add((Component)new OrientableLabel(StringResources.TEXT_FOR_HYPERLINK_C), c);
        c.fill = 2;
        this.tfLinkText = new GWTextField();
        c.gridy = 1;
        c.insets = new Insets(0, 15, 10, 15);
        pnl.add((Component)this.tfLinkText, c);
        c.fill = 0;
        c.gridy = 2;
        c.insets = new Insets(10, 15, 5, 15);
        if (this.isMailto) {
            pnl.add((Component)new OrientableLabel(StringResources.EKMAIL_ADDRESS_C), c);
        } else {
            pnl.add((Component)new OrientableLabel(StringResources.WEB_PAGE_LOCATION_C), c);
        }
        c.fill = 2;
        this.tfLinkHref = new ActionEnablerTextField(this.btnOk.getAction());
        c.gridy = 3;
        c.insets = new Insets(0, 15, 10, 15);
        pnl.add((Component)this.tfLinkHref, c);
        c.gridy = 4;
        c.insets.right = 10;
        pnl.add((Component)this.buildButtonsPanel(), c);
        this.tfLinkHref.setColumns(30);
        this.getContentPane().add((Component)pnl, "Center");
    }

    private JPanel buildButtonsPanel() {
        OrientablePanel content = new OrientablePanel(new FlowLayout(4, 5, 5));
        content.add(this.btnOk);
        content.add(this.btnCancel);
        this.setDefaultButton(this.btnOk);
        this.setCancelButton(this.btnCancel);
        return content;
    }

    public void setLinkText(String theText) {
        this.tfLinkText.setText(theText);
    }

    public String getLinkText() {
        return this.tfLinkText.getText();
    }

    public String getLink() {
        String link = "";
        if (this.isMailto) {
            link = "mailto:" + this.tfLinkHref.getText();
        } else {
            link = this.tfLinkHref.getText();
            if (link.toLowerCase().startsWith("www")) {
                link = "http://" + link;
            }
        }
        return link;
    }

    public boolean isActionCompleteSuccessfully() {
        return this.isActionCompletedSuccesevely;
    }

    JTextField getTfLinkHref() {
        return this.tfLinkHref;
    }

    class BtnCancelAction
    extends AbstractAction {
        public BtnCancelAction() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent e) {
            InsertLinkDialog.this.isActionCompletedSuccesevely = false;
            InsertLinkDialog.this.dispose();
        }
    }

    class BtnOKAction
    extends AbstractAction {
        public BtnOKAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent e) {
            if (InsertLinkDialog.this.tfLinkHref.getText().length() == 0) {
                JOptionPane.showMessageDialog(InsertLinkDialog.this, StringResources.INSERT_A_WEB_PAGE_LOCATION);
                InsertLinkDialog.this.tfLinkHref.grabFocus();
                return;
            }
            if (InsertLinkDialog.this.tfLinkText.getText().length() == 0) {
                InsertLinkDialog.this.tfLinkText.setText(InsertLinkDialog.this.tfLinkHref.getText());
            }
            InsertLinkDialog.this.isActionCompletedSuccesevely = true;
            InsertLinkDialog.this.dispose();
        }
    }
}

