/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.htmleditor.DirtyStateManager;
import com.appframework.mvc.MVCController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.text.JTextComponent;

public class MultipleFieldsDirtyStateManager
extends DirtyStateManager {
    private Map dirtyComponents = new HashMap();

    public MultipleFieldsDirtyStateManager(MVCController theController) {
        super(theController);
    }

    public boolean isDirty() {
        boolean res;
        boolean dirty;
        Set keys = this.dirtyComponents.keySet();
        Iterator i = keys.iterator();
        for (res = false; i.hasNext() && !res; res |= dirty) {
            JTextComponent tc = (JTextComponent)i.next();
            dirty = (Boolean)this.dirtyComponents.get(tc);
        }
        return res;
    }

    public void clearDirtyState() {
        super.clearDirtyState();
        Set keys = this.dirtyComponents.keySet();
        for (JTextComponent tc : keys) {
            this.dirtyComponents.put(tc, Boolean.FALSE);
        }
    }

    public synchronized void setDirty(JTextComponent theTextComponent, boolean isDirty) {
        if (theTextComponent != null) {
            this.addComponent(theTextComponent);
            this.dirtyComponents.put(theTextComponent, isDirty);
        }
    }

    public synchronized void addComponent(JTextComponent component) {
        if (component != null && !this.dirtyComponents.containsKey(component)) {
            this.dirtyComponents.put(component, Boolean.FALSE);
        }
    }
}

