/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.htmleditor.GwRTFEditorKit;
import com.appframework.components.htmleditor.HTMLStyledEditorKit;
import com.appframework.components.htmleditor.HTMLTextPane;
import com.appframework.components.htmleditor.MyImageView;
import com.appframework.components.htmleditor.StyledHTMLFactory;
import com.appframework.utils.OS;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;

public class PrintHTMLTextPane
extends HTMLTextPane {
    public FontMetrics getFontMetrics(Font font) {
        Font result = font;
        if (this.mode == 1 && (OS.isLinuxOS() || OS.isWinOS())) {
            result = this.increaseFontSize(font);
        }
        return super.getFontMetrics(result);
    }

    public StyledEditorKit createEditorKit(int theMode) {
        StyledEditorKit kit = null;
        if (theMode == 1) {
            kit = new PrintHTMLEditorKit(this.isEditable());
        } else if (theMode == 2 || theMode == 3) {
            kit = new GwRTFEditorKit(theMode);
        }
        return kit;
    }

    private static class PrintHTMLEditorKit
    extends HTMLStyledEditorKit {
        public PrintHTMLEditorKit() {
        }

        public PrintHTMLEditorKit(boolean isEditMode) {
            super(isEditMode);
            this.myFactory = new StyledHTMLFactory(){

                public View create(Element elem) {
                    View view = super.create(elem);
                    if (view instanceof MyImageView) {
                        ((MyImageView)view).setLoadsSynchronously(true);
                    }
                    return view;
                }
            };
        }

        public Document createDefaultDocument() {
            Document document = super.createDefaultDocument();
            ((HTMLDocument)document).setAsynchronousLoadPriority(-1);
            return document;
        }
    }
}

