/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor.ui;

import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import sun.awt.AppContext;
import sun.awt.dnd.SunDragSourceContextPeer;

class DragRecognitionSupport_CLONE {
    private int motionThreshold;
    private MouseEvent dndArmedEvent;
    private JComponent component;

    DragRecognitionSupport_CLONE() {
    }

    private static DragRecognitionSupport_CLONE getDragRecognitionSupport() {
        DragRecognitionSupport_CLONE support = (DragRecognitionSupport_CLONE)AppContext.getAppContext().get(DragRecognitionSupport_CLONE.class);
        if (support == null) {
            support = new DragRecognitionSupport_CLONE();
            AppContext.getAppContext().put(DragRecognitionSupport_CLONE.class, support);
        }
        return support;
    }

    public static boolean mousePressed(MouseEvent me) {
        return DragRecognitionSupport_CLONE.getDragRecognitionSupport().mousePressedImpl(me);
    }

    public static MouseEvent mouseReleased(MouseEvent me) {
        return DragRecognitionSupport_CLONE.getDragRecognitionSupport().mouseReleasedImpl(me);
    }

    public static boolean mouseDragged(MouseEvent me, BeforeDrag bd) {
        return DragRecognitionSupport_CLONE.getDragRecognitionSupport().mouseDraggedImpl(me, bd);
    }

    private void clearState() {
        this.dndArmedEvent = null;
        this.component = null;
    }

    private int mapDragOperationFromModifiers(MouseEvent me, TransferHandler th) {
        if (th == null || !SwingUtilities.isLeftMouseButton(me)) {
            return 0;
        }
        return SunDragSourceContextPeer.convertModifiersToDropAction(me.getModifiersEx(), th.getSourceActions(this.component));
    }

    private boolean mousePressedImpl(MouseEvent me) {
        this.component = (JComponent)me.getSource();
        if (this.mapDragOperationFromModifiers(me, this.component.getTransferHandler()) != 0) {
            this.motionThreshold = DragSource.getDragThreshold();
            this.dndArmedEvent = me;
            return true;
        }
        this.clearState();
        return false;
    }

    private MouseEvent mouseReleasedImpl(MouseEvent me) {
        if (this.dndArmedEvent == null) {
            return null;
        }
        MouseEvent retEvent = null;
        if (me.getSource() == this.component) {
            retEvent = this.dndArmedEvent;
        }
        this.clearState();
        return retEvent;
    }

    private boolean mouseDraggedImpl(MouseEvent me, BeforeDrag bd) {
        TransferHandler th;
        int action;
        if (this.dndArmedEvent == null) {
            return false;
        }
        if (me.getSource() != this.component) {
            this.clearState();
            return false;
        }
        int dx = Math.abs(me.getX() - this.dndArmedEvent.getX());
        int dy = Math.abs(me.getY() - this.dndArmedEvent.getY());
        if ((dx > this.motionThreshold || dy > this.motionThreshold) && (action = this.mapDragOperationFromModifiers(me, th = this.component.getTransferHandler())) != 0) {
            if (bd != null) {
                bd.dragStarting(this.dndArmedEvent);
            }
            th.exportAsDrag(this.component, this.dndArmedEvent, action);
            this.clearState();
        }
        return true;
    }

    public static interface BeforeDrag {
        public void dragStarting(MouseEvent var1);
    }
}

