/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.multyactionlabel;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ShiftedIcon
extends ImageIcon {
    private int shift = 0;
    private Icon icon;
    private BufferedImage bufferedImage;

    public ShiftedIcon(int theShift, Icon theIcon) {
        this.shift = theShift;
        this.icon = theIcon;
        this.bufferedImage = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        this.setImage(this.bufferedImage);
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.bufferedImage = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        this.setImage(this.bufferedImage);
        Graphics2D gr = this.bufferedImage.createGraphics();
        gr.setColor(g.getColor());
        if (this.icon != null) {
            this.icon.paintIcon(c, gr, this.shift, 0);
            g.drawImage(this.getImage(), x, y, this.getImageObserver());
        }
    }

    public int getIconWidth() {
        return (this.icon == null ? 0 : this.icon.getIconWidth()) + this.shift;
    }

    public int getIconHeight() {
        return this.icon == null ? 0 : this.icon.getIconHeight();
    }
}

