/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.level;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Level {
    private long ID;
    private Level parent = null;
    private List<Level> children = new ArrayList<Level>();

    protected Level(long theID, Level theParent) {
        this.ID = theID;
        this.parent = theParent;
        if (this.parent != null) {
            this.parent.add(this);
        }
    }

    protected Level(long theID) {
        this(theID, null);
    }

    protected long getID() {
        return this.ID;
    }

    public Level getParent() {
        return this.parent;
    }

    public List<Level> getChildren() {
        return this.children;
    }

    public void add(Level level) {
        this.children.add(level);
    }

    public void remove(Level level) {
        this.children.remove(level);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Level)) {
            return false;
        }
        Level level = (Level)o;
        return this.ID == level.ID;
    }

    public int hashCode() {
        return (int)(this.ID ^ this.ID >>> 32);
    }

    public void setParent(Level level) {
        if (this.parent != null) {
            this.parent.remove(this);
        }
        this.parent = level;
        if (this.parent != null) {
            this.parent.add(this);
        }
    }

    public String toString() {
        long parentID = -1L;
        if (this.parent != null) {
            parentID = this.parent.ID;
        }
        return "level: ID = [" + this.ID + "]; ParentID = [" + parentID + ']';
    }
}

