/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.mvc;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrameActionList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventManager;
import com.appframework.event.ICanDie;
import com.appframework.level.Level;
import com.appframework.level.LevelManager;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.Command;
import com.appframework.mvc.ControllerManager;
import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.LocalCommand;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.GWClientActionList;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.componentrelated.ComponentRelatedAction;
import com.novell.gw.jclient.application.notify.NotifyActionList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MVCController<T extends MVCView> {
    private static Logger logger = Logger.getLogger(MVCController.class);
    protected Level level;
    private T view;
    private boolean enabled = true;
    private List<AppEventListenerDescriptor> listenersDescriptors;
    private int listenersAdded;
    private int listenersRemoved;
    private Class<? extends ComponentRelatedAction> type;

    public MVCController(Level parentLevel) {
        this(LevelManager.getInstance().createLevel(), parentLevel);
    }

    protected MVCController(Level level, Level parentLevel) {
        this.level = level;
        this.level.setParent(parentLevel);
        ControllerManager.getInstance().add(this);
        this.listenersDescriptors = new ArrayList<AppEventListenerDescriptor>();
        this.initListeners();
    }

    public void prepareForRelease() {
        if (this.getMVCView() instanceof ICanDie) {
            ((ICanDie)this.getMVCView()).die();
        }
    }

    public MVCController(T view, MVCController parentController) {
        this(view, parentController, null);
    }

    public MVCController(T view, MVCController parentController, Class<? extends ComponentRelatedAction> type) {
        this(parentController.level);
        this.view = view;
        this.type = type;
    }

    public void bindActionKey(AppAction action, KeyStroke oldKey, KeyStroke newKey) {
        T view = this.getMVCView();
        JComponent component = null;
        int option = 0;
        if (view instanceof JComponent) {
            component = (JComponent)view;
            option = 1;
        } else if (view instanceof RootPaneContainer) {
            component = (JComponent)((RootPaneContainer)view).getContentPane();
            option = 2;
        }
        if (component != null) {
            Object o;
            InputMap inputMap = component.getInputMap(option);
            ActionMap actionMap = component.getActionMap();
            ActionKey newAction = action.getActionKey();
            actionMap.put((Object)newAction, action);
            if (newKey != null) {
                Object oldAction = inputMap.get(newKey);
                if (oldAction != null && !oldAction.equals((Object)newAction)) {
                    logger.warn((Object)("Replacing [" + oldAction + "] with [" + (Object)((Object)newAction) + "] in " + component.getClass().getSimpleName()));
                }
                inputMap.put(newKey, (Object)newAction);
            }
            if (oldKey != null && !oldKey.equals(newKey) && (o = inputMap.get(oldKey)) != null && o.equals((Object)newAction)) {
                inputMap.remove(oldKey);
            }
        }
    }

    private void bindActionKeys() {
        Class<ComponentRelatedAction> type = this.getType();
        if (type != null && this.getMVCView() instanceof JComponent) {
            ActionList actionList = this.getActionList();
            while (actionList != null) {
                Collection<AppAction> actions = actionList.getActions();
                for (AppAction action : actions) {
                    KeyStroke keyStroke;
                    if (!type.isInstance(action) || (keyStroke = action.getAccelerator()) == null) continue;
                    this.bindActionKey(action, null, keyStroke);
                }
                MVCController<MVCView> controller = actionList.getParentController();
                actionList = controller == null ? null : controller.getActionList();
            }
        }
    }

    protected void initListeners() {
    }

    public void addListenerDescriptor(AppEventListenerDescriptor listenerDescriptor) {
        if (listenerDescriptor == null) {
            return;
        }
        listenerDescriptor.setController(this);
        listenerDescriptor.getListener().setListenerEnabled(this.enabled);
        if (!this.listenersDescriptors.contains(listenerDescriptor)) {
            this.listenersDescriptors.add(listenerDescriptor);
            AppEventManager.getInstance().addListener(listenerDescriptor.getLevel(), listenerDescriptor.getCommandID(), listenerDescriptor.getListener());
            ++this.listenersAdded;
        } else {
            logger.warn((Object)("Trying to add existing listener descriptor: [" + listenerDescriptor + ']'));
        }
    }

    public void removeListenerDescriptor(AppEventListenerDescriptor theListenerDescriptor) {
        if (theListenerDescriptor == null) {
            return;
        }
        if (this.listenersDescriptors.contains(theListenerDescriptor)) {
            try {
                this.listenersDescriptors.remove(theListenerDescriptor);
                AppEventManager.getInstance().removeListener(theListenerDescriptor.getLevel(), theListenerDescriptor.getCommandID(), theListenerDescriptor.getListener());
                ++this.listenersRemoved;
            }
            catch (Exception e) {
                logger.warn((Object)("Trying to remove non-existant listener descriptor: [" + theListenerDescriptor + ']'));
            }
        } else {
            logger.warn((Object)("Trying to remove unregistered listener descriptor: [" + theListenerDescriptor + ']'));
        }
    }

    public void removeAllListenerDescriptors() {
        int listenersInManager = AppEventManager.getInstance().getListenersCount();
        try {
            while (!this.listenersDescriptors.isEmpty()) {
                this.removeListenerDescriptor(this.listenersDescriptors.get(0));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception removing ListenerDescriptors: " + e.getLocalizedMessage()));
        }
        int listenersRemovedFromManager = listenersInManager - AppEventManager.getInstance().getListenersCount();
        if (this.listenersRemoved != this.listenersAdded || this.listenersRemoved != listenersRemovedFromManager) {
            logger.warn((Object)("Wrong count of listener removed. Listeners added: [" + this.listenersAdded + "] " + "Listeners removed: [" + this.listenersRemoved + "] " + "Listeners removed from AppEventManager: [" + listenersRemovedFromManager + ']'));
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public void setMVCView(T view) {
        this.view = view;
    }

    public T getMVCView() {
        return this.view;
    }

    public MVCController<? extends MVCView> getParentController() {
        return ControllerManager.getInstance().get(this.level.getParent());
    }

    public MVCController getParentController(Class aClass) {
        if (this.getClass() == aClass) {
            return this;
        }
        MVCController<MVCView> parentController = this.getParentController();
        if (parentController == null) {
            return null;
        }
        if (parentController.getClass() == aClass) {
            return parentController;
        }
        return parentController.getParentController(aClass);
    }

    public boolean isChildOf(MVCController parentController) {
        if (parentController == null) {
            throw new IllegalArgumentException("controller is null");
        }
        Level level = this.level;
        while ((level = level.getParent()) != null) {
            if (ControllerManager.getInstance().get(level) != parentController) continue;
            return true;
        }
        return false;
    }

    public boolean isChildOf(Class<? extends MVCController> parentControllerClass) {
        if (parentControllerClass == null) {
            throw new IllegalArgumentException("parentControllerClass is null");
        }
        Level level = this.level;
        while ((level = level.getParent()) != null) {
            if (!ControllerManager.getInstance().get(level).getClass().equals(parentControllerClass)) continue;
            return true;
        }
        return false;
    }

    public ActionList getActionList() {
        MVCController<MVCView> result;
        for (result = this; !(result instanceof ActionList) && result != null; result = result.getParentController()) {
        }
        if (result != null) {
            return (ActionList)result;
        }
        return null;
    }

    public void processCommand(Command theCommand) {
        this.doProcessCommand(theCommand);
    }

    private void doProcessCommand(Command theCommand) {
        AppEvent event = new AppEvent(theCommand.getID());
        event.setSource(this);
        event.setData(theCommand.getCommandObject());
        event.setAttributes(theCommand.getAttributes());
        if (theCommand instanceof GlobalCommand) {
            event.setLevel(LevelManager.getInstance().getGlobalLevel());
            AppEventManager.getInstance().processGlobalEvent(event);
        } else if (theCommand instanceof LocalCommand) {
            LocalCommand cmd = (LocalCommand)theCommand;
            event.setLevel(cmd.getTopController().level);
            AppEventManager.getInstance().processEvent(event);
        } else {
            event.setLevel(this.getFrameLevel());
            AppEventManager.getInstance().processEvent(event);
        }
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
        int nSize = this.listenersDescriptors.size();
        for (int i = 0; i < nSize; ++i) {
            AppEventListenerDescriptor descriptor = this.listenersDescriptors.get(i);
            descriptor.getListener().setListenerEnabled(b);
        }
        this.setEnabledForChildrens(b);
    }

    private void setEnabledForChildrens(boolean isEnabled) {
        List<Level> childrens = this.level.getChildren();
        int nSize = childrens.size();
        for (int i = 0; i < nSize; ++i) {
            Level level = childrens.get(i);
            ControllerManager.getInstance().get(level).setEnabled(isEnabled);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Level getFrameLevel() {
        MVCController<MVCView> parentController;
        MVCController<MVCView> currentController = this;
        if (this.isReleased()) {
            throw new IllegalArgumentException("This controller is released: " + this);
        }
        Level globalLevel = LevelManager.getInstance().getGlobalLevel();
        if (currentController.getLevel().equals(globalLevel)) {
            throw new IllegalStateException("This is Global level controller");
        }
        do {
            if (currentController instanceof ApplicationFrameActionList || currentController instanceof GWClientActionList || currentController instanceof NotifyActionList) {
                return currentController.getLevel();
            }
            parentController = currentController.getParentController();
            if (parentController != null) continue;
            throw new IllegalStateException("this controller has no parent but shoul have it: " + currentController + " > probably its frame is disposing");
        } while (!(currentController = parentController).getLevel().equals(globalLevel));
        throw new IllegalStateException("Global level controller reached, but frame level controller not found,\n original controller: " + this + "\n parent controller: " + this.getParentController());
    }

    public synchronized boolean isReleased() {
        return ControllerManager.getInstance().get(this.level) == null;
    }

    public Class<? extends ComponentRelatedAction> getType() {
        return this.type;
    }

    public void setType(Class<? extends ComponentRelatedAction> type) {
        this.type = type;
        this.bindActionKeys();
    }

    public String toString() {
        MVCController<MVCView> parent = this.getParentController();
        String string = this.getClass().getSimpleName() + "[ level: " + this.level + "]";
        if (parent != null) {
            string = string + " child of " + parent.toString();
        }
        return string;
    }
}

