/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.utils;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class DoubleImageIcon
extends ImageIcon {
    private ImageIcon main;
    private Icon additional;

    public DoubleImageIcon(ImageIcon main, Icon additionalIcon) {
        if (main == null || additionalIcon == null) {
            throw new NullPointerException();
        }
        this.main = main;
        this.additional = additionalIcon;
    }

    public ImageIcon getMainIcon() {
        return this.main;
    }

    public Icon getAdditionalIcon() {
        return this.additional;
    }

    public AccessibleContext getAccessibleContext() {
        return this.main.getAccessibleContext();
    }

    public String getDescription() {
        return this.main.getDescription();
    }

    public int getIconHeight() {
        return this.main.getIconHeight();
    }

    public int getIconWidth() {
        return this.main.getIconWidth();
    }

    public Image getImage() {
        return this.main.getImage();
    }

    public int getImageLoadStatus() {
        return this.main.getImageLoadStatus();
    }

    public ImageObserver getImageObserver() {
        return this.main.getImageObserver();
    }

    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        this.main.paintIcon(c, g, x, y);
        this.additional.paintIcon(c, g, x, y);
    }

    public void setDescription(String description) {
        this.main.setDescription(description);
    }

    public void setImage(Image image) {
        this.main.setImage(image);
    }

    public void setImageObserver(ImageObserver observer) {
        this.main.setImageObserver(observer);
    }

    public String toString() {
        return this.main.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DoubleImageIcon)) {
            return false;
        }
        DoubleImageIcon that = (DoubleImageIcon)o;
        if (this.additional != null ? !this.additional.equals(that.additional) : that.additional != null) {
            return false;
        }
        return !(this.main != null ? !this.main.equals(that.main) : that.main != null);
    }

    public int hashCode() {
        int result = this.main != null ? this.main.hashCode() : 0;
        result = 31 * result + (this.additional != null ? this.additional.hashCode() : 0);
        return result;
    }
}

