/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.utils;

import com.appframework.utils.FactoryConfigurationException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import sun.misc.Service;

public final class InstanceLoader {
    private static Logger logger = Logger.getLogger(InstanceLoader.class);

    public static Object loadInstance(Class theClass, String defaultClassName) throws FactoryConfigurationException {
        Iterator serviceProviders = Service.providers((Class)theClass);
        Object result = null;
        while (serviceProviders.hasNext()) {
            result = serviceProviders.next();
            if (result == null) continue;
            return result;
        }
        String className = System.getProperty(theClass.getName());
        if (className == null) {
            className = defaultClassName;
            logger.warn((Object)"Using default ...");
        }
        try {
            result = Class.forName(className).newInstance();
        }
        catch (Exception e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
            throw new FactoryConfigurationException();
        }
        if (result == null) {
            throw new FactoryConfigurationException();
        }
        return result;
    }
}

