/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.utils;

import com.appframework.Tested;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interval<T extends Comparable> {
    private T start;
    private T end;

    @Tested
    public Interval(T start, T end) {
        if (start == null) {
            throw new IllegalArgumentException("start is null");
        }
        if (end == null) {
            throw new IllegalArgumentException("end is null");
        }
        if (start.compareTo(end) > 0) {
            throw new IllegalArgumentException("start is greater than end");
        }
        this.start = start;
        this.end = end;
    }

    public T getEnd() {
        return this.end;
    }

    public T getStart() {
        return this.start;
    }

    @Tested
    public boolean contains(T object) {
        if (object == null) {
            throw new IllegalArgumentException("object is null");
        }
        return this.start.compareTo(object) <= 0 && this.end.compareTo(object) >= 0;
    }

    public String toString() {
        return "Interval[start = " + this.start + ", end = " + this.end + ']';
    }
}

