/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.utils;

import com.appframework.AppAction;
import com.appframework.components.customizedbutton.ToolBarColorButton;
import com.appframework.components.customizedbutton.ToolBarColorToggleButton;
import com.appframework.utils.JavaVendor;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.controls.orientable.MenuItemFactory;
import com.novell.gw.jclient.application.controls.orientable.OrientableMenuItem;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButtonMenuItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public final class OS {
    private static Logger logger = Logger.getLogger(OS.class);
    private static boolean MacOS = false;
    private static boolean WinOS = false;
    private static boolean LinuxOS = false;
    private static boolean i386Arch = true;
    private static boolean AquaLAF = false;
    private static boolean KDESession = false;
    private static boolean GNOMESession = false;
    private static int MetaKey;
    private static Locale myLocale;
    private static String javaVersion;
    private static int javaVersionMajor;
    private static int javaVersionMinor;
    private static int javaVersionRevision;
    private static int javaVersionBuild;
    private static JavaVendor javaVendor;
    private static String osVersion;

    private static void setMacPreferences() {
        UIManager.put("JFileChooser.appBundleIsTraversable", "never");
        UIManager.put("JFileChooser.packageIsTraversable", "never");
        System.setProperty("apple.awt.use-file-dialog-packages", "true");
        System.setProperty("com.apple.eawt.CocoaComponent.CompatibilityMode", "false");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
    }

    public static void setMyLocale(Locale myLocale) {
        OS.myLocale = myLocale;
    }

    public static boolean isMacOS() {
        return MacOS;
    }

    public static boolean isWinOS() {
        return WinOS;
    }

    public static boolean is_i386Arch() {
        return i386Arch;
    }

    public static boolean isKDESession() {
        return KDESession;
    }

    public static boolean isGNOMESession() {
        return GNOMESession;
    }

    public static boolean isAquaLAF() {
        return AquaLAF;
    }

    public static boolean isNimbusLAF() {
        return UIManager.getLookAndFeel() != null && UIManager.getLookAndFeel().getName().equals("Nimbus");
    }

    public static boolean isMetalLAF() {
        return UIManager.getLookAndFeel() != null && UIManager.getLookAndFeel().getName().equals("Metal");
    }

    public static boolean isLinuxOS() {
        return LinuxOS;
    }

    public static int getMetaKey() {
        return MetaKey;
    }

    public static String getLanguage() {
        String language = myLocale.getLanguage();
        logger.debug((Object)("language = " + language));
        return language;
    }

    public static String getDictLanguage() {
        String language = myLocale.getLanguage();
        String country = myLocale.getCountry();
        String variant = myLocale.getVariant();
        if (country != null && country.length() != 0 && !language.equalsIgnoreCase(country)) {
            language = new StringBuffer().append(language).append('-').append(country).toString();
        }
        logger.debug((Object)("country = " + country));
        logger.debug((Object)("variant = " + variant));
        logger.debug((Object)("language = " + language));
        return language;
    }

    public static boolean isLeftMouseButton(MouseEvent anEvent) {
        boolean rv = OS.isMacOS() ? SwingUtilities.isLeftMouseButton(anEvent) && !anEvent.isControlDown() : SwingUtilities.isLeftMouseButton(anEvent);
        return rv;
    }

    public static boolean isDoubleClick(MouseEvent event) {
        return SwingUtilities.isLeftMouseButton(event) && event.getClickCount() == 2;
    }

    public static JMenuItem createMenuItem(AppAction appAction) {
        JMenuItem menuItem = appAction.isCheckable() ? MenuItemFactory.createCkeckBoxMenuItem(appAction) : (appAction.isRadio() ? new OrientableRadioButtonMenuItem(appAction) : new OrientableMenuItem(appAction));
        if (MacOS) {
            menuItem.setIcon(null);
        } else {
            Integer mnemonic = appAction.getMnemonicKey();
            Integer mnemonicIndex = appAction.getMnemonicIndex();
            if (mnemonic != null && mnemonicIndex != null && mnemonicIndex != -1) {
                menuItem.setDisplayedMnemonicIndex(mnemonicIndex);
            }
        }
        return menuItem;
    }

    public static AbstractButton createToolBarButton(AppAction appAction) {
        AbstractButton button = appAction.isCheckable() || appAction.isRadio() ? new ToolBarColorToggleButton(appAction) : new ToolBarColorButton(appAction);
        return button;
    }

    public static JMenuItem createMenuItemForAction(Action theAction) {
        return OS.createMenuItemForAction(theAction, false);
    }

    public static JMenuItem createMenuItemForAction(Action theAction, boolean checkBox) {
        JMenuItem menuItem = checkBox ? MenuItemFactory.createCkeckBoxMenuItem(theAction) : new OrientableMenuItem(theAction);
        if (MacOS) {
            menuItem.setIcon(null);
        }
        return menuItem;
    }

    public static void addButtons(JPanel thePanel, JButton btnOk, JButton btnCancel) {
        if (OS.isMacOS()) {
            thePanel.add(btnCancel);
            thePanel.add(btnOk);
        } else {
            thePanel.add(btnOk);
            thePanel.add(btnCancel);
        }
    }

    public static void addButtons(JPanel thePanel, JButton btnOk, JButton btnCancel, JButton btnThree) {
        if (OS.isMacOS()) {
            thePanel.add(btnThree);
            thePanel.add(btnCancel);
            thePanel.add(btnOk);
        } else {
            thePanel.add(btnOk);
            thePanel.add(btnCancel);
            thePanel.add(btnThree);
        }
    }

    public static OrientablePanel buildButtonsPanel(JButton actionButton, JButton cancelButton, JButton dataLossButton, JButton changeContentButton) {
        JButton[] jButtonArray;
        if (changeContentButton == null) {
            jButtonArray = null;
        } else {
            JButton[] jButtonArray2 = new JButton[1];
            jButtonArray = jButtonArray2;
            jButtonArray2[0] = changeContentButton;
        }
        return OS.buildButtonsPanel(actionButton, cancelButton, dataLossButton, jButtonArray);
    }

    public static OrientablePanel buildButtonsPanel(JButton actionButton, JButton cancelButton, JButton dataLossButton, JButton[] changeContentButtons) {
        if (actionButton == null && cancelButton == null && dataLossButton == null) {
            throw new IllegalArgumentException("no button provided");
        }
        JButton[] buttons = OS.isMacOS() ? new JButton[]{dataLossButton, cancelButton, actionButton} : new JButton[]{actionButton, dataLossButton, cancelButton};
        int regularInterval = 12;
        int dataLossInterval = 24;
        GridBagConstraints constraints = new GridBagConstraints();
        OrientablePanel leftPanel = null;
        if (changeContentButtons != null) {
            leftPanel = new OrientablePanel();
            leftPanel.setLayout(new GridBagLayout());
            constraints.insets = new Insets(regularInterval, regularInterval, regularInterval, 0);
            for (JButton button : changeContentButtons) {
                leftPanel.add((Component)button, constraints);
                ++constraints.gridx;
            }
        }
        OrientablePanel rightPanel = new OrientablePanel();
        rightPanel.setLayout(new GridBagLayout());
        constraints.insets = new Insets(regularInterval, regularInterval, regularInterval, regularInterval);
        if (buttons[0] != null) {
            if (OS.isMacOS() && (buttons[1] != null || buttons[2] != null)) {
                constraints.insets.right = dataLossInterval;
            }
            rightPanel.add(buttons[0]);
            constraints.insets.right = regularInterval;
            ++constraints.gridx;
        }
        if (buttons[1] != null) {
            rightPanel.add((Component)buttons[1], constraints);
            ++constraints.gridx;
        }
        if (buttons[2] != null) {
            rightPanel.add((Component)buttons[2], constraints);
        }
        OrientablePanel boxPanel = new OrientablePanel();
        boxPanel.setLayout(new BoxLayout(boxPanel, 2));
        if (leftPanel != null) {
            boxPanel.add(leftPanel);
        }
        boxPanel.add(Box.createHorizontalGlue());
        boxPanel.add(rightPanel);
        return boxPanel;
    }

    public static int getJavaVersionMajor() {
        return javaVersionMajor;
    }

    public static int getJavaVersionMinor() {
        return javaVersionMinor;
    }

    public static int getjavaVersionBuild() {
        return javaVersionBuild;
    }

    public static JavaVendor getJavaVendor() {
        return javaVendor;
    }

    public static boolean isTrayIconSupported() {
        boolean supported = false;
        if (OS.getJavaVersionMajor() > 1 || OS.getJavaVersionMajor() == 1 && OS.getJavaVersionMinor() >= 6) {
            supported = OS.isLinuxOS() && OS.isKDESession() && javaVersion.compareTo("1.6.0_03") >= 0 ? true : true;
        }
        return supported;
    }

    public static String getOsVersion() {
        return osVersion;
    }

    static {
        javaVersionMajor = -1;
        javaVersionMinor = -1;
        javaVersionRevision = -1;
        javaVersionBuild = -1;
        osVersion = null;
        String osArch = System.getProperty("os.arch");
        String osName = System.getProperty("os.name");
        if (osName.equals("Mac OS X")) {
            MacOS = true;
            if (osArch.equals("ppc")) {
                i386Arch = false;
            }
            OS.setMacPreferences();
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            String currentLAFName = lookAndFeel.getName();
            if (currentLAFName.equals("Mac OS X Aqua")) {
                AquaLAF = true;
            }
        } else if (osName.indexOf("Win") != -1) {
            WinOS = true;
        } else if (osName.equals("Linux")) {
            LinuxOS = true;
            KDESession = Utils.isKDESession();
            GNOMESession = Utils.isGNOMESession();
            logger.debug((Object)("KDE: " + KDESession));
            logger.debug((Object)("Gnome: " + GNOMESession));
        }
        osVersion = System.getProperty("os.version");
        logger.debug((Object)("os.version: " + osVersion));
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        MetaKey = defaultToolkit.getMenuShortcutKeyMask();
        myLocale = Locale.getDefault();
        javaVersion = System.getProperty("java.version");
        logger.debug((Object)("java.version: " + javaVersion));
        Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)\\p{Punct}*((\\d*)\\w*)\\p{Punct}*((\\d*)\\w*)");
        Matcher m = pattern.matcher(javaVersion);
        if (m.matches()) {
            javaVersionMajor = Integer.parseInt(m.group(1));
            javaVersionMinor = Integer.parseInt(m.group(2));
            javaVersionRevision = Integer.parseInt(m.group(3));
            if (m.group(5) != null && m.group(5).length() > 0) {
                javaVersionBuild = Integer.parseInt(m.group(5));
            }
        }
        String propertyVendor = System.getProperty("java.vendor");
        logger.debug((Object)("java.vendor: " + propertyVendor));
        javaVendor = JavaVendor.getVendor(propertyVendor);
    }
}

