/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.utils;

import com.appframework.utils.OS;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.apache.log4j.Logger;

public class ProxyDesktop {
    private static Logger logger = Logger.getLogger(ProxyDesktop.class);
    private static ProxyDesktop instance;
    private static Object desktop;

    private ProxyDesktop() {
    }

    public static boolean isDesktopSupported() {
        boolean supported = false;
        try {
            if (OS.getJavaVersionMajor() > 1 || OS.getJavaVersionMajor() == 1 && OS.getJavaVersionMinor() >= 6) {
                Class<?> desktopClass = Class.forName("java.awt.Desktop");
                supported = (Boolean)desktopClass.getMethod("isDesktopSupported", null).invoke(null, new Object[0]);
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return supported;
    }

    public static ProxyDesktop getDesktop() {
        if (!ProxyDesktop.isDesktopSupported()) {
            throw new UnsupportedOperationException("desktop is not supported");
        }
        if (instance == null) {
            try {
                Class<?> desktopClass = Class.forName("java.awt.Desktop");
                desktop = desktopClass.getMethod("getDesktop", null).invoke(null, new Object[0]);
                instance = new ProxyDesktop();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        return instance;
    }

    public boolean isSupported(Action action) {
        if (desktop == null) {
            throw new IllegalStateException("desktop is null");
        }
        if (action != Action.BROWSE) {
            throw new IllegalArgumentException("action " + (Object)((Object)action) + " is not supported yet");
        }
        boolean supported = false;
        try {
            Class<?> desktopClass = Class.forName("java.awt.Desktop");
            Class<?> desktopActionClass = Class.forName("java.awt.Desktop$Action");
            Field browseField = desktopActionClass.getDeclaredField("BROWSE");
            Object parameter = browseField.get(null);
            logger.debug((Object)("parameter: " + parameter + ", class: " + parameter.getClass().getName()));
            supported = (Boolean)desktopClass.getMethod("isSupported", desktopActionClass).invoke(desktop, parameter);
        }
        catch (Exception e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
        return supported;
    }

    public void browse(URI uri) throws IOException {
        if (!this.isSupported(Action.BROWSE)) {
            throw new UnsupportedOperationException("" + (Object)((Object)Action.BROWSE) + " action is not supported");
        }
        try {
            Class<?> desktopClass = Class.forName("java.awt.Desktop");
            desktopClass.getMethod("browse", URI.class).invoke(desktop, uri);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        OPEN,
        EDIT,
        PRINT,
        MAIL,
        BROWSE;

    }
}

