/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.utils;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.util.BitSet;
import org.apache.log4j.Logger;
import sun.security.action.GetPropertyAction;

public class XMLStringDecoderEncoder {
    private static Logger logger = Logger.getLogger(XMLStringDecoderEncoder.class);
    static BitSet dontNeedEncoding;
    static final int caseDiff = 32;
    static String dfltEncName;

    public static String encode(String s) {
        String str = null;
        try {
            str = XMLStringDecoderEncoder.encode(s, dfltEncName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return str;
    }

    public static String encode(String s, String enc) throws UnsupportedEncodingException {
        boolean needToChange = false;
        boolean wroteUnencodedChar = false;
        int maxBytesPerChar = 10;
        StringBuffer out = new StringBuffer(s.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)buf, enc));
        int nSize = s.length();
        for (int i = 0; i < nSize; ++i) {
            int c = s.charAt(i);
            if (dontNeedEncoding.get(c)) {
                if (c == 32) {
                    c = 32;
                    needToChange = true;
                }
                out.append((char)c);
                wroteUnencodedChar = true;
                continue;
            }
            try {
                char d;
                if (wroteUnencodedChar) {
                    writer = new BufferedWriter(new OutputStreamWriter((OutputStream)buf, enc));
                    wroteUnencodedChar = false;
                }
                writer.write(c);
                if (c >= 55296 && c <= 56319 && i + 1 < nSize && (d = s.charAt(i + 1)) >= '\udc00' && d <= '\udfff') {
                    writer.write(d);
                    ++i;
                }
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            byte[] ba = buf.toByteArray();
            int nBufLen = ba.length;
            for (int j = 0; j < nBufLen; ++j) {
                out.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            buf.reset();
            needToChange = true;
        }
        return needToChange ? out.toString() : s;
    }

    public static String decode(String s) {
        String str = null;
        try {
            str = XMLStringDecoderEncoder.decode(s, dfltEncName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return str;
    }

    public static String decode(String s, String enc) throws UnsupportedEncodingException {
        boolean needToChange = false;
        StringBuffer sb = new StringBuffer();
        int numChars = s.length();
        int i = 0;
        if (enc.length() == 0) {
            throw new UnsupportedEncodingException("URLDecoder: empty string encoding parameter");
        }
        block5: while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '%': {
                    try {
                        byte[] bytes = new byte[(numChars - i) / 3];
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            bytes[pos++] = (byte)Integer.parseInt(s.substring(i + 1, i + 3), 16);
                            if ((i += 3) >= numChars) continue;
                            c = s.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            throw new IllegalArgumentException("URLDecoder: Incomplete trailing escape (%) pattern");
                        }
                        sb.append(new String(bytes, 0, pos, enc));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - " + e.getMessage());
                    }
                    needToChange = true;
                    continue block5;
                }
            }
            sb.append(c);
            ++i;
        }
        return needToChange ? sb.toString() : s;
    }

    static {
        dfltEncName = null;
        dontNeedEncoding = new BitSet(256);
        for (int i = 0; i < 256; ++i) {
            if (i <= 7 || i == 9 || i == 11 || i == 12 || i >= 14 && i <= 31 || i == 38 || i == 37) continue;
            dontNeedEncoding.set(i);
        }
        dfltEncName = AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
    }
}

