/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.utils.wait;

import com.appframework.utils.wait.DelayTimerCallback;
import org.apache.log4j.Logger;

public class DelayTimer
extends Thread {
    private static Logger logger = Logger.getLogger(DelayTimer.class);
    private final DelayTimerCallback callback;
    private final Object mutex = new Object();
    private final Object triggeredMutex = new Object();
    private final long delay;
    private boolean quit;
    private boolean triggered;
    private long waitTime;

    public DelayTimer(DelayTimerCallback callback, long delay) {
        this.callback = callback;
        this.delay = delay;
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTimer() {
        Object object = this.mutex;
        synchronized (object) {
            this.waitTime = this.delay;
            this.mutex.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTimer() {
        try {
            Object object = this.mutex;
            synchronized (object) {
                Object object2 = this.triggeredMutex;
                synchronized (object2) {
                    if (this.triggered) {
                        this.triggeredMutex.wait();
                    }
                }
                this.waitTime = 0L;
                this.mutex.notify();
            }
        }
        catch (InterruptedException ie) {
            logger.error((Object)ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                if (this.quit) break;
                Object object = this.mutex;
                synchronized (object) {
                    if (this.waitTime < 0L) {
                        this.triggered = true;
                        this.waitTime = 0L;
                    } else {
                        long saveWaitTime = this.waitTime;
                        this.waitTime = -1L;
                        this.mutex.wait(saveWaitTime);
                    }
                }
                try {
                    if (!this.triggered) continue;
                    this.callback.trigger();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                finally {
                    Object e = this.triggeredMutex;
                    synchronized (e) {
                        this.triggered = false;
                        this.triggeredMutex.notify();
                    }
                }
            }
            catch (InterruptedException ie) {
                logger.error((Object)ie);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() {
        Object object = this.mutex;
        synchronized (object) {
            this.quit = true;
            this.mutex.notify();
        }
    }
}

