/*
 * Decompiled with CFR 0.152.
 */
package com.apple_wrappers;

import com.apple_wrappers.ApplicationListenerWrapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class ApplicationWrapper {
    private static final Logger logger = Logger.getLogger(ApplicationWrapper.class);
    private static ApplicationWrapper applicationWrapper;
    private Object application;

    private ApplicationWrapper() throws ClassNotFoundException {
        Class<?> instanceClass = Class.forName("com.apple.eawt.Application");
        try {
            Method method = instanceClass.getMethod("getApplication", new Class[0]);
            this.application = method.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
        }
    }

    public static ApplicationWrapper getApplication() throws ClassNotFoundException {
        if (applicationWrapper == null) {
            applicationWrapper = new ApplicationWrapper();
        }
        return applicationWrapper;
    }

    public void setEnabledPreferencesMenu(boolean enabled) {
        try {
            Class<?> aClass = this.application.getClass();
            Method method = aClass.getMethod("setEnabledPreferencesMenu", Boolean.TYPE);
            method.invoke(this.application, enabled);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
        }
    }

    public void setDockIconBadge(String text) {
        try {
            Class<?> aClass = this.application.getClass();
            Method method = aClass.getMethod("setDockIconBadge", String.class);
            method.invoke(this.application, text);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
        }
    }

    public void addApplicationListener(ApplicationListenerWrapper listener) {
        try {
            Class<?> aClass = this.application.getClass();
            Class<?> parameterType = Class.forName("com.apple.eawt.ApplicationListener");
            Method method = aClass.getMethod("addApplicationListener", parameterType);
            method.invoke(this.application, listener.getNative());
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
        }
    }
}

