/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.api.impl;

import com.novell.gw.ab.AddressBookItemList;
import com.novell.gw.ab.Contact;
import com.novell.gw.engine.Category;
import com.novell.gw.engine.CategoryList;
import com.novell.gw.engine.ColumnFieldInfo;
import com.novell.gw.engine.DataStore;
import com.novell.gw.engine.DisplaySettings;
import com.novell.gw.engine.GroupHeader;
import com.novell.gw.engine.Item;
import com.novell.gw.engine.ItemList;
import com.novell.gw.folder.Folder;
import com.novell.gw.jclient.api.impl.APIWrappingConfigurator;
import com.novell.gw.jclient.api.impl.CategoryImpl;
import com.novell.gw.jclient.api.impl.CategoryListImpl;
import com.novell.gw.jclient.api.impl.ColumnAndSortInfoImpl;
import com.novell.gw.jclient.api.impl.ColumnFieldInfoImpl;
import com.novell.gw.jclient.api.impl.DataStoreImpl;
import com.novell.gw.jclient.api.impl.DisplaySettingsImpl;
import com.novell.gw.jclient.api.impl.GroupHeaderImpl;
import com.novell.gw.jclient.api.impl.GroupHeaderImpl_Cached;
import com.novell.gw.jclient.api.impl.ItemListImpl;
import com.novell.gw.jclient.api.impl.ItemListImpl_Cached;
import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.impl.folder.APIFolderWrapperManager;
import com.novell.gw.jclient.api.impl.message.APIMessageWrapperManager;
import com.novell.gw.jclient.api.interfaces.ICategory;
import com.novell.gw.jclient.api.interfaces.ICategoryList;
import com.novell.gw.jclient.api.interfaces.IColumnAndSortInfo;
import com.novell.gw.jclient.api.interfaces.IColumnFieldInfo;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.api.interfaces.IFolderDisplaySettings;
import com.novell.gw.jclient.api.interfaces.IGroupHeader;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IPanelDisplaySettings;
import com.novell.gw.message.Message;
import org.apache.log4j.Logger;

public class APIWrapperManager {
    private static Logger logger = Logger.getLogger(APIWrapperManager.class);

    public static IDataStore getDataStore(DataStore dataStore) {
        if (dataStore == null) {
            return null;
        }
        return new DataStoreImpl(dataStore);
    }

    public static IItem getItem(Item item) {
        if (item == null) {
            return null;
        }
        if (item instanceof Folder) {
            return APIFolderWrapperManager.getFolder((Folder)item);
        }
        if (item instanceof GroupHeader) {
            return APIWrapperManager.getGroupHeader((GroupHeader)item);
        }
        if (item instanceof Message) {
            return APIMessageWrapperManager.getMessage((Message)item);
        }
        if (item instanceof Contact) {
            return APIAbWrapperManager.getContact((Contact)item);
        }
        throw new IllegalStateException("unexpected item type: " + item.getClass().getName());
    }

    public static IItem[] getItemArray(Item[] itemArray) {
        if (itemArray == null) {
            return null;
        }
        IItem[] itemWrapperArray = new IItem[itemArray.length];
        for (int i = 0; i < itemArray.length; ++i) {
            itemWrapperArray[i] = APIWrapperManager.getItem(itemArray[i]);
        }
        return itemWrapperArray;
    }

    public static Item[] getNativeItemArray(IItem[] itemArray) {
        if (itemArray == null) {
            return null;
        }
        Item[] nativeItemArray = new Item[itemArray.length];
        for (int i = 0; i < itemArray.length; ++i) {
            if (itemArray[i] == null) {
                nativeItemArray[i] = null;
                logger.warn((Object)"item wrapper array element is null");
                continue;
            }
            nativeItemArray[i] = itemArray[i].getNativeItem();
        }
        return nativeItemArray;
    }

    public static ColumnFieldInfo[] getNativeColumnFieldInfoArray(IColumnFieldInfo[] fieldInfoArray) {
        if (fieldInfoArray == null) {
            return null;
        }
        ColumnFieldInfo[] nativeFieldInfoArray = new ColumnFieldInfo[fieldInfoArray.length];
        for (int i = 0; i < fieldInfoArray.length; ++i) {
            if (fieldInfoArray[i] == null) {
                nativeFieldInfoArray[i] = null;
                logger.warn((Object)"item wrapper array element is null");
                continue;
            }
            nativeFieldInfoArray[i] = fieldInfoArray[i].getNativeColumnFieldInfo();
        }
        return nativeFieldInfoArray;
    }

    public static IGroupHeader getGroupHeader(GroupHeader groupHeader) {
        if (groupHeader == null) {
            return null;
        }
        return APIWrapperManager.wrapGroupHeader(groupHeader);
    }

    public static IItemList getItemList(ItemList itemList) {
        if (itemList == null) {
            return null;
        }
        if (itemList instanceof AddressBookItemList) {
            return APIAbWrapperManager.getAddressBookItemList((AddressBookItemList)itemList);
        }
        return APIWrapperManager.wrapItemList(itemList);
    }

    public static ICategory getCategory(Category category) {
        if (category == null) {
            return null;
        }
        return new CategoryImpl(category);
    }

    public static ICategoryList getCategoryList(CategoryList categoryList) {
        if (categoryList == null) {
            return null;
        }
        return new CategoryListImpl(categoryList);
    }

    public static ICategory createCategory(IDataStore dataStore, String name) {
        return new CategoryImpl(new Category(dataStore.getNativeDataStore(), name));
    }

    public static ICategoryList createCategoryList(int numSelectedItems) {
        return new CategoryListImpl(new CategoryList(numSelectedItems));
    }

    public static ICategoryList createCategoryList(IDataStore dataStore) {
        return new CategoryListImpl(new CategoryList(dataStore.getNativeDataStore()));
    }

    public static ICategoryList createCategoryList(IDataStore dataStore, IItem item) {
        return new CategoryListImpl(new CategoryList(dataStore.getNativeDataStore(), item.getNativeItem()));
    }

    public static ICategoryList createCategoryList(IDataStore dataStore, IItem[] items) {
        return new CategoryListImpl(new CategoryList(dataStore.getNativeDataStore(), APIWrapperManager.getNativeItemArray(items)));
    }

    public static IColumnFieldInfo getColumnFieldInfo(ColumnFieldInfo columnFieldInfo) {
        if (columnFieldInfo == null) {
            return null;
        }
        return new ColumnFieldInfoImpl(columnFieldInfo);
    }

    public static IColumnFieldInfo createColumnFieldInfo(String name, int id, int width, int sortOption) {
        return new ColumnFieldInfoImpl(name, id, width, sortOption);
    }

    public static IColumnFieldInfo createColumnFieldInfo(int id, int width, int sortOption) {
        return new ColumnFieldInfoImpl(id, width, sortOption);
    }

    public static IColumnFieldInfo[] getColumnFieldInfoArray(ColumnFieldInfo[] infoArray) {
        if (infoArray == null) {
            return null;
        }
        IColumnFieldInfo[] infoWrapperArray = new IColumnFieldInfo[infoArray.length];
        for (int i = 0; i < infoArray.length; ++i) {
            infoWrapperArray[i] = APIWrapperManager.getColumnFieldInfo(infoArray[i]);
        }
        return infoWrapperArray;
    }

    public static IColumnAndSortInfo createColumnAndSortInfo(DisplaySettings.ColumnAndSortInfo columnAndSortInfo) {
        if (columnAndSortInfo == null) {
            return null;
        }
        return new ColumnAndSortInfoImpl(columnAndSortInfo);
    }

    public static IPanelDisplaySettings createPanelDisplaySettings(IDataStore dataStore) {
        DisplaySettingsImpl displaySettings = new DisplaySettingsImpl(new DisplaySettings(dataStore.getNativeDataStore()));
        displaySettings.setContacts(false);
        return displaySettings;
    }

    public static IPanelDisplaySettings createPanelDisplaySettings(IDataStore dataStore, boolean bContactsSubType) {
        DisplaySettingsImpl displaySettings = new DisplaySettingsImpl(new DisplaySettings(dataStore.getNativeDataStore(), bContactsSubType));
        displaySettings.setContacts(bContactsSubType);
        return displaySettings;
    }

    public static IPanelDisplaySettings createPanelDisplaySettings(IDataStore dataStore, IPanelDisplaySettings templateDisplaySettings) {
        DisplaySettingsImpl displaySettings = new DisplaySettingsImpl(new DisplaySettings(dataStore.getNativeDataStore(), templateDisplaySettings.getNativeDisplaySettings()));
        if (templateDisplaySettings instanceof DisplaySettingsImpl) {
            displaySettings.setContacts(((DisplaySettingsImpl)templateDisplaySettings).isContacts());
        }
        return displaySettings;
    }

    public static IFolderDisplaySettings createFolderDisplaySettings(IDataStore dataStore, String name, String description, int contactTypeMask, IColumnFieldInfo[] visibleColumns, IColumnFieldInfo sortField) {
        DisplaySettingsImpl displaySettings = new DisplaySettingsImpl(new DisplaySettings(dataStore.getNativeDataStore(), name, description, contactTypeMask, APIWrapperManager.getNativeColumnFieldInfoArray(visibleColumns), sortField == null ? null : sortField.getNativeColumnFieldInfo()));
        displaySettings.setContacts(true);
        return displaySettings;
    }

    public static IFolderDisplaySettings createFolderDisplaySettings(IDataStore dataStore, String name, String description, int itemType, IColumnFieldInfo[] visibleColumns, IColumnFieldInfo sortField, int boxTypeMask, int viewMode) {
        DisplaySettingsImpl displaySettings = new DisplaySettingsImpl(new DisplaySettings(dataStore.getNativeDataStore(), name, description, itemType, APIWrapperManager.getNativeColumnFieldInfoArray(visibleColumns), sortField == null ? null : sortField.getNativeColumnFieldInfo(), boxTypeMask, viewMode));
        displaySettings.setContacts(false);
        return displaySettings;
    }

    public static IPanelDisplaySettings getPanelDisplaySettings(DisplaySettings displaySettings) {
        return displaySettings == null ? null : new DisplaySettingsImpl(displaySettings);
    }

    public static IFolderDisplaySettings getFolderDisplaySettings(DisplaySettings displaySettings) {
        return displaySettings == null ? null : new DisplaySettingsImpl(displaySettings);
    }

    private static IGroupHeader wrapGroupHeader(GroupHeader groupHeader) {
        assert (groupHeader != null);
        IGroupHeader impl = new GroupHeaderImpl(groupHeader);
        if (APIWrappingConfigurator.getImplementationMap().get(IGroupHeader.class) == GroupHeaderImpl_Cached.class) {
            impl = new GroupHeaderImpl_Cached(impl);
        }
        return impl;
    }

    private static IItemList wrapItemList(ItemList itemList) {
        assert (itemList != null);
        IItemList impl = new ItemListImpl(itemList);
        if (APIWrappingConfigurator.getImplementationMap().get(IItemList.class) == ItemListImpl_Cached.class) {
            impl = new ItemListImpl_Cached(impl);
        }
        return impl;
    }
}

