/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.api.impl;

import com.novell.gw.engine.CategoryList;
import com.novell.gw.jclient.api.APIInternal;
import com.novell.gw.jclient.api.enums.CategoryListRecordStatusType;
import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.interfaces.ICategory;
import com.novell.gw.jclient.api.interfaces.ICategoryList;

public class CategoryListImpl
implements ICategoryList {
    protected CategoryList categoryList;

    protected CategoryListImpl(CategoryList categoryList) {
        if (categoryList == null) {
            throw new IllegalArgumentException("category list is null");
        }
        this.categoryList = categoryList;
    }

    public String toString() {
        return this.categoryList.toString();
    }

    @APIInternal
    public CategoryList getNativeCategoryList() {
        return this.categoryList;
    }

    public boolean addCategory(ICategory category, CategoryListRecordStatusType iStatus) {
        return this.categoryList.addCategory(category.getNativeCategory(), iStatus.getValue());
    }

    public boolean addCategory(ICategory category, CategoryListRecordStatusType iStatus, boolean bWasPrimary) {
        return this.categoryList.addCategory(category.getNativeCategory(), iStatus.getValue(), bWasPrimary);
    }

    public int findCategoryIndex(ICategory category) {
        return this.categoryList.findCategoryIndex(category.getNativeCategory());
    }

    public ICategory getCategoryAt(int index) {
        return APIWrapperManager.getCategory(this.categoryList.getCategoryAt(index));
    }

    public String getName(int index) {
        return this.categoryList.getName(index);
    }

    public CategoryListRecordStatusType getState(int index) {
        return CategoryListRecordStatusType.getEnum(this.categoryList.getState(index));
    }

    public int getUseCnt(int index) {
        return this.categoryList.getUseCnt(index);
    }

    public int getPrimaryUseCnt(int index) {
        return this.categoryList.getPrimaryUseCnt(index);
    }

    public boolean isPrimary(int index) {
        return this.categoryList.isPrimary(index);
    }

    public boolean wasPrimary(int index) {
        return this.categoryList.wasPrimary(index);
    }

    public boolean isRemoved(int index) {
        return this.categoryList.isRemoved(index);
    }

    public int getCount() {
        return this.categoryList.getCount();
    }

    public int getItemCount() {
        return this.categoryList.getItemCount();
    }

    public ICategory getPrimary() {
        return APIWrapperManager.getCategory(this.categoryList.getPrimary());
    }

    public boolean setPrimary(ICategory category, boolean bIsPrimary, CategoryListRecordStatusType iStatus) {
        return this.categoryList.setPrimary(category.getNativeCategory(), bIsPrimary, iStatus.getValue());
    }

    public boolean setState(ICategory category, CategoryListRecordStatusType iStatus) {
        return this.categoryList.setState(category.getNativeCategory(), iStatus.getValue());
    }

    public boolean isModified() {
        return this.categoryList.isModified();
    }

    public void resetState() {
        this.categoryList.resetState();
    }

    public void clear() {
        this.categoryList.clear();
    }

    public void dispose() {
        this.categoryList.dispose();
    }
}

