/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.api.impl;

import com.novell.gw.ab.AddressBookManager;
import com.novell.gw.ab.PersonalAddressBook;
import com.novell.gw.account.Account;
import com.novell.gw.account.AccountSettings;
import com.novell.gw.account.ImapAccount;
import com.novell.gw.account.NntpAccount;
import com.novell.gw.account.Pop3Account;
import com.novell.gw.engine.DataStore;
import com.novell.gw.engine.DataStoreListener;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.engine.DisplaySettings;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.engine.JunkMail;
import com.novell.gw.engine.ProxyAccessList;
import com.novell.gw.engine.ProxyHistoryList;
import com.novell.gw.folder.FolderSharedList;
import com.novell.gw.jclient.api.enums.DataStoreAccessRequestType;
import com.novell.gw.jclient.api.enums.DataStoreDisplaySettingsSubtype;
import com.novell.gw.jclient.api.enums.FolderType;
import com.novell.gw.jclient.api.enums.ItemType;
import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.impl.DisplaySettingsImpl;
import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.impl.folder.APIFolderWrapperManager;
import com.novell.gw.jclient.api.impl.message.APIMessageWrapperManager;
import com.novell.gw.jclient.api.interfaces.ICategory;
import com.novell.gw.jclient.api.interfaces.IColumnFieldInfo;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.api.interfaces.IFolderDisplaySettings;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IPanelDisplaySettings;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.message.Message;
import com.novell.gw.notification.NotifySubscribeList;
import com.novell.gw.rules.RuleList;
import com.novell.gw.rules.VacationRuleInfo;
import java.util.Date;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataStoreImpl
implements IDataStore {
    private DataStore dataStore;

    DataStoreImpl(DataStore dataStore) {
        if (dataStore == null) {
            throw new IllegalArgumentException("dataStore is null");
        }
        this.dataStore = dataStore;
    }

    public String toString() {
        return this.dataStore.toString();
    }

    @Override
    public DataStore getNativeDataStore() {
        return this.dataStore;
    }

    @Override
    public void addDataStoreListener(DataStoreListener listener) {
        this.dataStore.addDataStoreListener(listener);
    }

    @Override
    public void removeDataStoreListener(DataStoreListener listener) {
        this.dataStore.removeDataStoreListener(listener);
    }

    @Override
    public IFolder createFolder(String name, String description, IFolder parent, int position) {
        return APIFolderWrapperManager.getFolder(this.dataStore.createFolder(name, description, parent.getNativeFolder(), position));
    }

    @Override
    public PersonalAddressBook createContactsFolder(String strName, IFolder parentFolder) {
        return this.dataStore.createContactsFolder(strName, parentFolder.getNativeFolder());
    }

    @Override
    public IFolder createSharedFolder(String name, String description, IFolder parent, int position, FolderSharedList sharedList) {
        return APIFolderWrapperManager.getFolder(this.dataStore.createSharedFolder(name, description, parent.getNativeFolder(), position, sharedList));
    }

    @Override
    public ImapAccount createImapAccount(String name, String imapServer, String imapUserName, String smtpServer, String emailAddress, String fromName, IFolder parentFolder, int position) {
        return this.dataStore.createImapAccount(name, imapServer, imapUserName, smtpServer, emailAddress, fromName, parentFolder.getNativeFolder(), position);
    }

    @Override
    public Pop3Account createPop3Account(String name, String pop3Server, String pop3UserName, String smtpServer, String emailAddress, String fromName, IFolder folder) {
        return this.dataStore.createPop3Account(name, pop3Server, pop3UserName, smtpServer, emailAddress, fromName, folder.getNativeFolder());
    }

    @Override
    public NntpAccount createNntpAccount(String name, boolean requiresAuth, String nntpServer, String nntpUserName, String nntpPassword, String emailAddress, String fromName, IFolder parentFolder, int position) {
        return this.dataStore.createNntpAccount(name, requiresAuth, nntpServer, nntpUserName, nntpPassword, emailAddress, fromName, parentFolder.getNativeFolder(), position);
    }

    @Override
    public void deleteAccount(Account account) {
        this.dataStore.deleteAccount(account);
    }

    @Override
    public RuleList getRuleList() {
        return this.dataStore.getRuleList();
    }

    @Override
    public DataStoreSettings getSettings() {
        return this.dataStore.getSettings();
    }

    @Override
    public JunkMail getJunkMail() {
        return this.dataStore.getJunkMail();
    }

    @Override
    public boolean hasMailboxSpace() {
        return this.dataStore.hasMailboxSpace();
    }

    @Override
    public boolean isOnline() {
        return this.dataStore.isOnline();
    }

    @Override
    public boolean isCaching() {
        return this.dataStore.isCaching();
    }

    @Override
    public boolean isRemote() {
        return this.dataStore.isRemote();
    }

    @Override
    public void sync() {
        this.dataStore.sync();
    }

    @Override
    public void emptyJunkMail() {
        this.dataStore.emptyJunkMail();
    }

    @Override
    public void emptyTrash() {
        this.dataStore.emptyTrash();
    }

    @Override
    public IFolder find(ItemListFilter filter) {
        return APIFolderWrapperManager.getFolder(this.dataStore.find(filter));
    }

    @Override
    public IFolder find(String from, String to, String subject, String message, String category) {
        return APIFolderWrapperManager.getFolder(this.dataStore.find(from, to, subject, message, category));
    }

    @Override
    public IItem findItem(String itemGID) {
        return APIWrapperManager.getItem(this.dataStore.findItem(itemGID));
    }

    @Override
    public IFolder getSystemFolder(FolderType folderType) {
        return APIFolderWrapperManager.getFolder(this.dataStore.getSystemFolder(folderType.getValue()));
    }

    @Override
    public IFolder[] getRootFolders() {
        return APIFolderWrapperManager.getFolderArray(this.dataStore.getRootFolders());
    }

    @Override
    public AddressBookManager getAddressBookManager() {
        return this.dataStore.getAddressBookManager();
    }

    @Override
    public Account[] getAccounts() {
        return this.dataStore.getAccounts();
    }

    @Override
    public Account[] moveAccountToIndex(Account account, int newIndex) {
        return this.dataStore.moveAccountToIndex(account, newIndex);
    }

    @Override
    public Account getAccount(String name) {
        return this.dataStore.getAccount(name);
    }

    @Override
    public Account getGroupWiseAccount() {
        return this.dataStore.getGroupWiseAccount();
    }

    @Override
    public AccountSettings getAccountSettings() {
        return this.dataStore.getAccountSettings();
    }

    @Override
    public IFolder findFolder(String name) {
        return APIFolderWrapperManager.getFolder(this.dataStore.findFolder(name));
    }

    @Override
    public IFolder findFolder(IFolder folder, IDataStore otherDataStore) {
        return APIFolderWrapperManager.getFolder(this.dataStore.findFolder(folder.getNativeFolder(), otherDataStore.getNativeDataStore()));
    }

    @Override
    public String getHost() {
        return this.dataStore.getHost();
    }

    @Override
    public String getPathToHost() {
        return this.dataStore.getPathToHost();
    }

    @Override
    public String getTcpIpAddress() {
        return this.dataStore.getTcpIpAddress();
    }

    @Override
    public String getTcpIpPort() {
        return this.dataStore.getTcpIpPort();
    }

    @Override
    public String getUserFileId() {
        return this.dataStore.getUserFileId();
    }

    @Override
    public String getUserId() {
        return this.dataStore.getUserId();
    }

    @Override
    public String getUserFullName() {
        return this.dataStore.getUserFullName();
    }

    @Override
    public IAddressable getUserFields() {
        return APIAbWrapperManager.getAddressable(this.dataStore.getUserFields());
    }

    @Override
    public boolean isArchiveDB() {
        return this.dataStore.isArchiveDB();
    }

    @Override
    public IDataStore openArchiveDB(boolean bForceRebuild) {
        return APIWrapperManager.getDataStore(this.dataStore.openArchiveDB(bForceRebuild));
    }

    @Override
    public boolean canDoNntpAccounts() {
        return this.dataStore.canDoNntpAccounts();
    }

    @Override
    public boolean canDoPopAndImapAccounts() {
        return this.dataStore.canDoPopAndImapAccounts();
    }

    @Override
    public boolean canSetOnlineMailboxPassword() {
        return this.dataStore.canSetOnlineMailboxPassword();
    }

    @Override
    public boolean validateOnlineMailboxPassword(String password) {
        return this.dataStore.validateOnlineMailboxPassword(password);
    }

    @Override
    public void reprimeCache() {
        this.dataStore.reprimeCache();
    }

    @Override
    public void requestContacts() {
        this.dataStore.requestContacts();
    }

    @Override
    public void requestSystemContacts() {
        this.dataStore.requestSystemContacts();
    }

    @Override
    public void setOnlineMailboxPassword(String oldPass, String newPass) {
        this.dataStore.setOnlineMailboxPassword(oldPass, newPass);
    }

    @Override
    public boolean isBackupDB() {
        return this.dataStore.isBackupDB();
    }

    @Override
    public IDataStore openBackupDB() {
        return APIWrapperManager.getDataStore(this.dataStore.openBackupDB());
    }

    @Override
    public boolean performBackupOnDB(boolean bForceBackup, boolean bExiting) {
        return this.dataStore.performBackupOnDB(bForceBackup, bExiting);
    }

    @Override
    public IFolder[] getCalendarFolders() {
        return APIFolderWrapperManager.getFolderArray(this.dataStore.getCalendarFolders());
    }

    @Override
    public IFolder[] getCalendarFolders(boolean bIncludeMainCalendar) {
        return APIFolderWrapperManager.getFolderArray(this.dataStore.getCalendarFolders());
    }

    @Override
    public int getCalendarFoldersCount() {
        return this.dataStore.getCalendarFoldersCount();
    }

    @Override
    public void initNavFolders() {
        this.dataStore.initNavFolders();
    }

    @Override
    public ICategory getCategory(String name) {
        return APIWrapperManager.getCategory(this.dataStore.getCategory(name));
    }

    @Override
    public ICategory getCategory(int index) {
        return APIWrapperManager.getCategory(this.dataStore.getCategory(index));
    }

    @Override
    public int getCategoryCount() {
        return this.dataStore.getCategoryCount();
    }

    @Override
    public Enumeration getCategoryEnumeration() {
        return this.dataStore.getCategoryEnumeration();
    }

    @Override
    public IColumnFieldInfo[] getDisplayColumnFields(boolean isContactType) {
        return APIWrapperManager.getColumnFieldInfoArray(this.dataStore.getDisplayColumnFields(isContactType));
    }

    @Override
    public IFolderDisplaySettings getDisplaySettings(String name) {
        return APIWrapperManager.getFolderDisplaySettings(this.dataStore.getDisplaySettings(name));
    }

    @Override
    public int getDisplaySettingsCount(DataStoreDisplaySettingsSubtype subType) {
        return this.dataStore.getDisplaySettingsCount(subType.getValue());
    }

    @Override
    public IPanelDisplaySettings getPanelTemplateSettings(int index) {
        IPanelDisplaySettings displaySettings = APIWrapperManager.getPanelDisplaySettings(this.dataStore.getPanelTemplateSettings(index));
        if (displaySettings instanceof DisplaySettingsImpl) {
            displaySettings.getPanelFolder(this);
        }
        return displaySettings;
    }

    @Override
    public int getPanelTemplateSettingsCount() {
        return this.dataStore.getPanelTemplateSettingsCount();
    }

    @Override
    public ItemListFilter getSavedFilter(int eFilterType, int index) {
        return this.dataStore.getSavedFilter(eFilterType, index);
    }

    @Override
    public int getSavedFilterCount(int eFilterType) {
        return this.dataStore.getSavedFilterCount(eFilterType);
    }

    @Override
    public Enumeration<IFolderDisplaySettings> getDisplaySettingsEnumeration(DataStoreDisplaySettingsSubtype subType) {
        boolean contacts = subType == DataStoreDisplaySettingsSubtype.CONTACTS;
        return new DisplaySettingEnumeration(this.dataStore.getDisplaySettingsEnumeration(subType.getValue()), contacts);
    }

    @Override
    public NotifySubscribeList getNotifySubscribeList() {
        return this.dataStore.getNotifySubscribeList();
    }

    @Override
    public ProxyAccessList getProxyAccessList() {
        return this.dataStore.getProxyAccessList();
    }

    @Override
    public ProxyHistoryList getProxyHistoryList() {
        return this.dataStore.getProxyHistoryList();
    }

    @Override
    public boolean importIcalFile(String filePath) {
        return this.dataStore.importIcalFile(filePath);
    }

    @Override
    public IMessage importMimeFile(String filePath) throws EngineException {
        Message message = this.dataStore.importMimeFile(filePath);
        return message == null ? null : APIMessageWrapperManager.getMessage(message);
    }

    @Override
    public boolean checkAccess(DataStoreAccessRequestType accessRequestType, ItemType itemType, int boxType) {
        return this.dataStore.checkAccess(accessRequestType.getValue(), itemType.getValue(), boxType);
    }

    @Override
    public boolean isGWCheckAvailable() {
        return this.dataStore.isGWCheckAvailable();
    }

    @Override
    public void flushSettings() {
        this.dataStore.flushSettings();
    }

    @Override
    public void dispose() {
        this.dataStore.dispose();
    }

    @Override
    public void writeMemoryCachedData() {
        this.dataStore.writeMemoryCachedData();
    }

    @Override
    public void clearAllAutoSavedMessages() {
        this.dataStore.clearAllAutoSavedMessages();
    }

    @Override
    public int getAutoSavedMessagesCount() {
        return this.dataStore.getAutoSavedMessagesCount();
    }

    @Override
    public IItem[] restoreAllAutoSavedMessages() {
        return APIWrapperManager.getItemArray(this.dataStore.restoreAllAutoSavedMessages());
    }

    @Override
    public boolean isCalendarFolderNameAlreadyExist(String calendarName) {
        return this.dataStore.isCalendarFolderNameAlreadyExist(calendarName);
    }

    @Override
    public String[] getIcalNameAndDescription(String filePath) {
        return this.dataStore.getIcalNameAndDescription(filePath);
    }

    @Override
    public boolean importIcalFile(String filePath, String calendarName, String calendarDescription, boolean bCreate) {
        return this.dataStore.importIcalFile(filePath, calendarName, calendarDescription, bCreate);
    }

    @Override
    public VacationRuleInfo getVacationRuleInfo() {
        return this.dataStore.getVacationRuleInfo();
    }

    @Override
    public boolean modifyVacationRule(String name, String replySubject, String replyMessage, boolean bActivate, Date startDate, Date endDate, boolean bReplyToExternalUsers) {
        return this.dataStore.modifyVacationRule(name, replySubject, replyMessage, bActivate, startDate, endDate, bReplyToExternalUsers);
    }

    @Override
    public boolean isVacationRuleActive() {
        return this.dataStore.isVacationRuleActive();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DisplaySettingEnumeration
    implements Enumeration<IFolderDisplaySettings> {
        private final Enumeration nativeEnumeration;
        private final boolean contacts;

        private DisplaySettingEnumeration(Enumeration nativeEnumeration, boolean contacts) {
            this.nativeEnumeration = nativeEnumeration;
            this.contacts = contacts;
        }

        @Override
        public boolean hasMoreElements() {
            return this.nativeEnumeration.hasMoreElements();
        }

        @Override
        public IFolderDisplaySettings nextElement() {
            IFolderDisplaySettings displaySettings = APIWrapperManager.getFolderDisplaySettings((DisplaySettings)this.nativeEnumeration.nextElement());
            if (displaySettings instanceof DisplaySettingsImpl) {
                ((DisplaySettingsImpl)displaySettings).setContacts(this.contacts);
            }
            return displaySettings;
        }
    }
}

