/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.api.impl;

import com.appframework.Tested;
import com.novell.gw.engine.Engine;
import com.novell.gw.engine.EngineCallback;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.LoginParameters;
import com.novell.gw.engine.ProxyHistoryEntry;
import com.novell.gw.jclient.api.enums.EngineLoginPrompt;
import com.novell.gw.jclient.api.enums.EngineMode;
import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.api.interfaces.IEngine;
import java.nio.charset.Charset;

public class EngineImpl
implements IEngine {
    private static EngineImpl engineImpl;
    private Engine engine = Engine.getInstance();

    public static EngineImpl getInstance() {
        if (engineImpl == null) {
            engineImpl = new EngineImpl();
        }
        return engineImpl;
    }

    public String toString() {
        return this.engine.toString();
    }

    public void cancelSync() {
        this.engine.cancelSync();
    }

    public boolean canDispose() {
        return this.engine.canDispose();
    }

    public void dispose() {
        this.engine.dispose();
    }

    public String getResourceString(int key) {
        return this.engine.getResourceString(key);
    }

    public void setCallback(EngineCallback callback) {
        this.engine.setCallback(callback);
    }

    public String getPathToCache() {
        return this.engine.getPathToCache();
    }

    public String getInstallLibPath() {
        return this.engine.getInstallLibPath();
    }

    public void setPathToCache(String pathToCache) {
        this.engine.setPathToCache(pathToCache);
    }

    public String getPathToRemote() {
        return this.engine.getPathToRemote();
    }

    public void setPathToRemote(String pathToRemote) {
        this.engine.setPathToRemote(pathToRemote);
    }

    public EngineMode switchMode(EngineMode newMode) {
        return EngineMode.getEnum(this.engine.switchMode(newMode.getValue()));
    }

    public boolean canSwitchMode(EngineMode newMode) {
        return this.engine.canSwitchMode(newMode.getValue());
    }

    public Charset getCharset() {
        return this.engine.getCharset();
    }

    public boolean isSSLActive() {
        return this.engine.isSSLActive();
    }

    public String getProductVersionName() {
        return this.engine.getProductVersionName();
    }

    public String getGWAPIJarVersion() {
        return this.engine.getGWAPIJarVersion();
    }

    @Tested(completely=false)
    public IDataStore loginOnline(String userId, String password, String serverAddr, int port) throws EngineException {
        return APIWrapperManager.getDataStore(this.engine.loginOnline(userId, password, serverAddr, port));
    }

    public IDataStore loginOnline(String userId, String password, String pathToHost) throws EngineException {
        return APIWrapperManager.getDataStore(this.engine.loginOnline(userId, password, pathToHost));
    }

    @Tested(completely=false)
    public IDataStore loginCaching(String pathToCache, String password) throws EngineException {
        return APIWrapperManager.getDataStore(this.engine.loginCaching(pathToCache, password));
    }

    public IDataStore loginRemote(String pathToRemote, String password) throws EngineException {
        return APIWrapperManager.getDataStore(this.engine.loginRemote(pathToRemote, password));
    }

    public IDataStore login(LoginParameters params, EngineLoginPrompt nPromptMode) throws EngineException {
        return APIWrapperManager.getDataStore(this.engine.login(params, nPromptMode.getValue()));
    }

    public IDataStore relogin() throws EngineException {
        return APIWrapperManager.getDataStore(this.engine.relogin());
    }

    public IDataStore getProxyDataStore(String userId, String userGUID) throws EngineException {
        return APIWrapperManager.getDataStore(this.engine.getProxyDataStore(userId, userGUID));
    }

    public IDataStore getProxyDataStore(ProxyHistoryEntry phe) throws EngineException {
        return APIWrapperManager.getDataStore(this.engine.getProxyDataStore(phe));
    }
}

