/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application;

import com.novell.gw.jclient.application.resources.StringResources;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ColorScheme {
    BLUE(1, StringResources.THEME_BLUE),
    OLIVE_GREEN(2, StringResources.THEME_OLIVE_GREEN),
    SILVER(3, StringResources.THEME_SILVER),
    SKY_BLUE(4, StringResources.THEME_SKY_BLUE),
    SPRING_GREEN(5, StringResources.THEME_SPRING_GREEN),
    STERLING_SILVER(6, StringResources.THEME_STERLING_SILVER);

    private static Logger logger;
    private static ColorScheme[] sortedValues;
    private final int apiId;
    private final String localizedName;

    private ColorScheme(int apiId, String localizedName) {
        this.apiId = apiId;
        this.localizedName = localizedName;
    }

    public int getApiId() {
        return this.apiId;
    }

    public String getLocalizedName() {
        return this.localizedName;
    }

    public static ColorScheme geEnum(int apiId) {
        for (ColorScheme scheme : ColorScheme.values()) {
            if (scheme.apiId != apiId) continue;
            return scheme;
        }
        logger.debug((Object)("illegal apiId passed: " + apiId + ", default ColorScheme would be returned"));
        return BLUE;
    }

    public static synchronized ColorScheme[] sortedValues() {
        if (sortedValues == null) {
            ColorScheme[] values = ColorScheme.values();
            TreeMap<String, ColorScheme> map = new TreeMap<String, ColorScheme>();
            for (ColorScheme colorScheme : values) {
                map.put(colorScheme.getLocalizedName(), colorScheme);
            }
            sortedValues = new ColorScheme[values.length];
            Iterator keys = map.keySet().iterator();
            int index = 0;
            while (keys.hasNext()) {
                ColorScheme.sortedValues[index] = (ColorScheme)((Object)map.get(keys.next()));
                ++index;
            }
        }
        return sortedValues;
    }

    static {
        logger = Logger.getLogger(ColorScheme.class);
        sortedValues = null;
    }
}

