/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application;

import com.appframework.utils.UIUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ExTableUI
extends BasicTableUI {
    private int startFrom;
    private int mergedCellsCount;
    private List rows = new ArrayList(5000);

    public ExTableUI() {
    }

    public ExTableUI(int startFrom, int mergedCellsCount, List rows) {
        this.startFrom = startFrom;
        this.mergedCellsCount = mergedCellsCount;
        this.rows = rows;
    }

    public void setStartFrom(int startFrom) {
        this.startFrom = startFrom;
    }

    public void setMergedCellsCount(int mergedCellsCount) {
        this.mergedCellsCount = mergedCellsCount;
    }

    public void setRows(List rows) {
        this.rows = rows;
    }

    public void paint(Graphics g, JComponent c) {
        boolean ltr;
        Rectangle clip = g.getClipBounds();
        Rectangle bounds = this.table.getBounds();
        bounds.y = 0;
        bounds.x = 0;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0 || !bounds.intersects(clip)) {
            return;
        }
        Point upperLeft = clip.getLocation();
        Point lowerRight = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        int rMin = this.table.rowAtPoint(upperLeft);
        int rMax = this.table.rowAtPoint(lowerRight);
        if (rMin == -1) {
            rMin = 0;
        }
        if (rMax == -1) {
            rMax = this.table.getRowCount() - 1;
        }
        int cMin = this.columnAtPoint(this.table, (ltr = this.table.getComponentOrientation().isLeftToRight()) ? upperLeft : lowerRight);
        int cMax = this.columnAtPoint(this.table, ltr ? lowerRight : upperLeft);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = this.table.getColumnCount() - 1;
        }
        if (this.rows.contains(new Integer(rMin))) {
            if (cMax == -1) {
                cMax = this.table.getColumnCount() - 1;
            }
            this.paintGrid(g, rMin, rMin, cMin, cMax);
            cMax = this.table.columnAtPoint(ltr ? lowerRight : upperLeft);
            if (cMax == -1) {
                cMax = this.table.getColumnCount() - 1;
            }
            this.paintCells(g, rMin, rMin, cMin, cMax);
            if (rMin + 1 <= rMax) {
                this.paintGrid(g, rMin + 1, rMax, cMin, cMax);
                this.paintCells(g, rMin + 1, rMax, cMin, cMax);
            }
        } else {
            this.paintGrid(g, rMin, rMax, cMin, cMax);
            this.paintCells(g, rMin, rMax, cMin, cMax);
        }
    }

    private int columnAtPoint(JTable table, Point point) {
        int index = table.columnAtPoint(point);
        Integer row = table.rowAtPoint(point);
        if (index >= this.startFrom && index < this.mergedCellsCount + this.startFrom && this.rows.contains(row)) {
            index = this.startFrom;
        }
        return index;
    }

    private void paintGrid(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        g.setColor(this.table.getGridColor());
        Rectangle minCell = this.getCellRect(this.table, rMin, cMin, true);
        Rectangle maxCell = this.getCellRect(this.table, rMax, cMax, true);
        Rectangle damagedArea = minCell.union(maxCell);
        if (this.table.getShowHorizontalLines()) {
            int tableWidth = damagedArea.x + damagedArea.width;
            int y = damagedArea.y;
            for (int row = rMin; row <= rMax; ++row) {
                g.drawLine(damagedArea.x, (y += this.table.getRowHeight(row)) - 1, tableWidth - 1, y - 1);
            }
        }
        if (this.table.getShowVerticalLines()) {
            int x;
            TableColumnModel cm = this.table.getColumnModel();
            int tableHeight = damagedArea.y + damagedArea.height;
            if (this.table.getComponentOrientation().isLeftToRight()) {
                x = damagedArea.x;
                for (int column = cMin; column <= cMax; ++column) {
                    int w = cm.getColumn(column).getWidth();
                    g.drawLine((x += w) - 1, 0, x - 1, tableHeight - 1);
                }
            } else {
                x = damagedArea.x + damagedArea.width;
                for (int column = cMin; column < cMax; ++column) {
                    int w = cm.getColumn(column).getWidth();
                    g.drawLine((x -= w) - 1, 0, x - 1, tableHeight - 1);
                }
                g.drawLine(x -= cm.getColumn(cMax).getWidth(), 0, x, tableHeight - 1);
            }
        }
    }

    private Rectangle getCellRect(JTable table, int row, int column, boolean b) {
        Rectangle cellRect = table.getCellRect(row, column, b);
        if (column == this.startFrom && this.rows.contains(new Integer(row))) {
            for (int i = this.startFrom + 1; i < this.mergedCellsCount + this.startFrom; ++i) {
                cellRect.width += table.getCellRect((int)row, (int)i, (boolean)true).width;
            }
            if (!UIUtils.getComponentOrientation().isLeftToRight()) {
                cellRect.x = table.getCellRect((int)row, (int)(this.mergedCellsCount + this.startFrom), (boolean)b).x;
            }
        }
        if (column < this.mergedCellsCount + this.startFrom && column > this.startFrom && this.rows.contains(new Integer(row))) {
            cellRect.width = 0;
        }
        return cellRect;
    }

    private void paintCells(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        JTableHeader header = this.table.getTableHeader();
        TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
        TableColumnModel cm = this.table.getColumnModel();
        for (int row = rMin; row <= rMax; ++row) {
            for (int column = cMin; column <= cMax; ++column) {
                Rectangle cellRect = this.getCellRect(this.table, row, column, false);
                TableColumn aColumn = cm.getColumn(column);
                if (aColumn == draggedColumn) continue;
                this.paintCell(g, cellRect, row, column);
            }
        }
        if (draggedColumn != null) {
            this.paintDraggedArea(g, rMin, rMax, draggedColumn, header.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    private void paintDraggedArea(Graphics g, int rMin, int rMax, TableColumn draggedColumn, int distance) {
        int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
        Rectangle minCell = this.getCellRect(this.table, rMin, draggedColumnIndex, true);
        Rectangle maxCell = this.getCellRect(this.table, rMax, draggedColumnIndex, true);
        Rectangle vacatedColumnRect = minCell.union(maxCell);
        g.setColor(this.table.getParent().getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        vacatedColumnRect.x += distance;
        g.setColor(this.table.getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        if (this.table.getShowVerticalLines()) {
            g.setColor(this.table.getGridColor());
            int x1 = vacatedColumnRect.x;
            int y1 = vacatedColumnRect.y;
            int x2 = x1 + vacatedColumnRect.width - 1;
            int y2 = y1 + vacatedColumnRect.height - 1;
            g.drawLine(x1 - 1, y1, x1 - 1, y2);
            g.drawLine(x2, y1, x2, y2);
        }
        for (int row = rMin; row <= rMax; ++row) {
            Rectangle r = this.getCellRect(this.table, row, draggedColumnIndex, false);
            r.x += distance;
            this.paintCell(g, r, row, draggedColumnIndex);
            if (!this.table.getShowHorizontalLines()) continue;
            g.setColor(this.table.getGridColor());
            Rectangle rcr = this.getCellRect(this.table, row, draggedColumnIndex, true);
            rcr.x += distance;
            int x1 = rcr.x;
            int y1 = rcr.y;
            int x2 = x1 + rcr.width - 1;
            int y2 = y1 + rcr.height - 1;
            g.drawLine(x1, y2, x2, y2);
        }
    }

    protected int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.table.getColumnModel();
        int nCount = cm.getColumnCount();
        for (int column = 0; column < nCount; ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    private void paintCell(Graphics g, Rectangle cellRect, int row, int column) {
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            Component component = this.table.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        } else {
            TableCellRenderer renderer = this.table.getCellRenderer(row, column);
            Component component = this.table.prepareRenderer(renderer, row, column);
            this.rendererPane.paintComponent(g, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        }
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        InputMap inputMap = this.table.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(36, 0), "selectFirstRow");
        inputMap.put(KeyStroke.getKeyStroke(35, 0), "selectLastRow");
        inputMap.put(KeyStroke.getKeyStroke(36, 1), "selectFirstRowExtendSelection");
        inputMap.put(KeyStroke.getKeyStroke(35, 1), "selectLastRowExtendSelection");
        ActionMap actionMap = this.table.getActionMap();
        actionMap.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        actionMap.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        actionMap.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
    }
}

