/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application;

import com.novell.gw.jclient.application.GWTable;
import java.util.HashSet;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

public class ExtendedGWTable
extends GWTable {
    public ExtendedGWTable() {
        this.init();
    }

    public ExtendedGWTable(TableModel dm) {
        super(dm);
        this.init();
    }

    public void tableChanged(TableModelEvent e) {
        int[] selectedRows = this.getSelectedRows();
        super.tableChanged(e);
        if (e.getType() == 0) {
            for (int i = 0; i < selectedRows.length; ++i) {
                int selectedRow = selectedRows[i];
                if (selectedRow >= this.getRowCount()) {
                    this.selectNearestRow(e.getLastRow());
                    continue;
                }
                this.addRowSelectionInterval(selectedRows[i], selectedRows[i]);
            }
        } else if (e.getType() == -1) {
            this.selectNearestRow(e.getLastRow());
        }
    }

    private void init() {
        HashSet<KeyStroke> keys = new HashSet<KeyStroke>(2);
        keys.add(KeyStroke.getKeyStroke(9, 0));
        this.setFocusTraversalKeys(0, keys);
        keys.clear();
        keys.add(KeyStroke.getKeyStroke(9, 64));
        this.setFocusTraversalKeys(1, keys);
    }

    private void updateIndices(TableModelEvent e, int[] indices) {
        int count = e.getLastRow() - e.getFirstRow();
        int lastIndex = e.getLastRow();
        for (int i = 0; i < indices.length; ++i) {
            if (lastIndex < indices[i]) continue;
            int j = i;
            while (j < indices.length) {
                int n = j++;
                indices[n] = indices[n] + count;
            }
            break;
        }
    }

    private void selectNearestRow(int theIndex) {
        int rowCount = this.getRowCount();
        if (theIndex >= 0 && theIndex < rowCount) {
            this.setRowSelectionInterval(theIndex, theIndex);
        } else if (rowCount > 0) {
            this.setRowSelectionInterval(--rowCount, rowCount);
        }
    }
}

