/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application;

import com.appframework.mvc.GlobalCommand;
import com.novell.gw.engine.DataStoreListener;
import com.novell.gw.folder.FolderChangeEvent;
import com.novell.gw.jclient.api.impl.folder.APIFolderWrapperManager;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.impl.cache.FoldersCache;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class FoldersChangeListener
implements DataStoreListener {
    private static Logger logger = Logger.getLogger(FoldersChangeListener.class);
    private String userGuid;

    public void folderChanged(FolderChangeEvent e) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doRefreshFolder(e);
        } else {
            SwingUtilities.invokeLater(new FolderEventRunnable(e));
        }
    }

    public void foldersChanged() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doRefreshFolders();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FoldersChangeListener.this.doRefreshFolders();
                }
            });
        }
    }

    public void settingsChanged(final int id) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doRefreshFolderSettings(id);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FoldersChangeListener.this.doRefreshFolderSettings(id);
                }
            });
        }
    }

    public void setUserGuid(String userGuid) {
        this.userGuid = userGuid;
    }

    private void doRefreshFolder(FolderChangeEvent e) {
        this.doRefreshFolders();
        if (e.getType() == 0) {
            GWClient.getApplication().processCommand(new GlobalCommand(1470, EngineCommandManager.getInstance(this.userGuid).getGWFolder(APIFolderWrapperManager.getFolder(e.getFolder()))));
        }
    }

    private void doRefreshFolders() {
        FoldersCache.clear(this.userGuid);
        GWClient.getApplication().processCommand(new GlobalCommand(200));
    }

    private void doRefreshFolderSettings(int theSettingsID) {
        GWClient.getApplication().processCommand(new GlobalCommand(1210, new Integer(theSettingsID)));
    }

    private class FolderEventRunnable
    implements Runnable {
        FolderChangeEvent e;

        public FolderEventRunnable(FolderChangeEvent e) {
            this.e = e;
        }

        public void run() {
            FoldersChangeListener.this.doRefreshFolder(this.e);
        }
    }
}

