/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application;

import com.appframework.ActionList;
import com.appframework.ApplicationFrame;
import com.appframework.ApplicationFrameActionList;
import com.appframework.listener.ListenerType;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.apple_wrappers.ApplicationWrapper;
import com.novell.gw.jclient.api.enums.EngineMode;
import com.novell.gw.jclient.api.interfaces.IFolderDisplaySettings;
import com.novell.gw.jclient.application.FolderLabelDropTargetListener;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.GWMainAppFrameActionList;
import com.novell.gw.jclient.application.GWMainAppFrameMainPanel;
import com.novell.gw.jclient.application.GWMainAppFrameToolBarsPanelsPane;
import com.novell.gw.jclient.application.HeaderPanelDropTargetListener;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.ActionQuickViewer;
import com.novell.gw.jclient.application.controls.Borders;
import com.novell.gw.jclient.application.controls.ColoredScrollPane;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.FocusTraversalPolicyDecorator;
import com.novell.gw.jclient.application.controls.filter.IFilterOwner;
import com.novell.gw.jclient.application.controls.filter.QuickFilterPanel;
import com.novell.gw.jclient.application.controls.folderstree.MainGWFoldersTree;
import com.novell.gw.jclient.application.controls.header.HeaderLabel;
import com.novell.gw.jclient.application.controls.header.HeaderPopupMenu;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListView;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListViewPanel;
import com.novell.gw.jclient.application.controls.itemview.QuickViewer;
import com.novell.gw.jclient.application.controls.itemview.QuickViewerLocation;
import com.novell.gw.jclient.application.controls.itemview.QuickViewerShowUpInfoProvider;
import com.novell.gw.jclient.application.controls.menus.AbstractActionsPopupMenu;
import com.novell.gw.jclient.application.controls.menus.GWApplicationFrameMenuBar;
import com.novell.gw.jclient.application.controls.menus.GWMenuBar;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.panelviews.MultiPanelView;
import com.novell.gw.jclient.application.controls.skinnable.SkinnablePanel;
import com.novell.gw.jclient.application.controls.storageswitcher.StorageSwitcher;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBarPanel;
import com.novell.gw.jclient.application.controls.toolbars.ItemListMiniToolBar;
import com.novell.gw.jclient.application.controls.toolbars.navigation.NavBarPanel;
import com.novell.gw.jclient.application.dialogs.folderproperties.CustomizePanelsDialog;
import com.novell.gw.jclient.application.frames.WindowFocusOwnerChangeListener;
import com.novell.gw.jclient.application.interfaces.ISelectedItemsInfo;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.filter.Filter;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;
import org.simplericity.macify.eawt.DefaultApplication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWMainAppFrame
extends ApplicationFrame<GWMainAppFrameActionList, Object>
implements QuickViewerShowUpInfoProvider,
IFilterOwner {
    private static Logger logger = Logger.getLogger(GWMainAppFrame.class);
    private static final String MULTI_PANEL_VIEW = "MULTI_PANEL_VIEW";
    private static final String ITEM_LIST_VIEW = "ITEM_LIST_VIEW";
    private static final int MAIN_WINDOW_DEFAULT_WIDTH = 820;
    private static final int VIEW_MULTI_PANEL_STATE = 3;
    private static final int VIEW_ITEM_LIST_VIEW_STATE = 4;
    private int numberOfUnreadItem = 0;
    private int viewState = 4;
    private JPanel tablePanelHolder;
    private static String basicTitle;
    private GWMainAppFrameMainPanel mainPanel;
    private JPanel tablePanel;
    private JPanel treePanel;
    private JPanel quickViewerPanel;
    private ColoredScrollPane scrollPaneTree;
    private MainGWFoldersTree tree;
    private QuickViewer quickViewer;
    private MultiPanelView multiPanelView;
    private ItemListMiniToolBar miniToolBar;
    private SkinnablePanel tableHeaderPanel;
    private SkinnablePanel treeHeaderPanel;
    private HeaderLabel folderLabel;
    private AbstractFolder folder;
    private HeaderPopupMenu headerPopupMenu;
    private NavBarPanel navigationBar;
    private StorageSwitcher treeStorageSwitcher;
    private StorageSwitcher tableStorageSwitcher;
    private JComponent headerRigidArea;
    private GWToolBarPanel toolBarNavBarPanel;
    private GWMainAppFrameToolBarsPanelsPane toolbarsPanel;
    private QuickFilterPanel pnlQuick;
    private ISelectedItemsInfo selectedItemsInfo;
    private String frameName = "";
    private static BufferedImage GW_DOCK_ICON;
    private ItemListView itemListView;

    public GWMainAppFrame() {
        this(EngineCommandManager.getUserGuid());
    }

    public GWMainAppFrame(String userGuid) {
        super(StringResources.NOVELL_GROUPWISE, "MAIN_FRAME", userGuid);
        basicTitle = StringResources.NOVELL_GROUPWISE;
        if (EngineCommandManager.getCurrentMode() == EngineMode.CACHING) {
            basicTitle = basicTitle + ' ' + StringResources.CACHING;
        }
        this.setTitle(basicTitle);
        this.frameName = basicTitle;
        this.setController(new GWMainAppFrameActionList(this, (MVCController)GWClient.getApplication()));
        this.buildUI();
        ((GWMainAppFrameActionList)this.getController()).setEnabled(true);
        this.miniToolBar.setVisible(!this.isMainToolBarVisible());
        this.initNavBar(true);
        this.toolBarNavBarPanel.add((Component)this.navigationBar, "North");
        boolean mainMenuVisible = GWCommandManager.getInstance(this.userGuid).getAppearanceSettings().isMainMenuVisible();
        ((GWMainAppFrameActionList)this.appActionList).processCommand(new Command(1850, mainMenuVisible));
        boolean navBarVisible = GWCommandManager.getInstance(this.userGuid).getAppearanceSettings().isNavBarVisible();
        this.setNavBarVisible(navBarVisible);
        this.updateNumberOfUnreadItem();
        this.repaintDocIconInMacOS();
    }

    @Override
    public String getName() {
        return this.frameName;
    }

    public JPanel getQuickViewerPanel() {
        if (this.quickViewer == null) {
            this.quickViewerPanel.add((Component)this.getQuickViewer(), "Center");
        }
        return this.quickViewerPanel;
    }

    public void initNavBar(boolean forceRefresh) {
        List<AbstractFolder> folders = this.retrieveFolders();
        List navBarFolderList = this.navigationBar.getFolderList();
        if (!forceRefresh && navBarFolderList != null && navBarFolderList.size() <= folders.size() && folders.containsAll(navBarFolderList)) {
            this.navigationBar.updateFolderNames(folders);
            this.navigationBar.setFolderList(folders);
            return;
        }
        this.navigationBar.setNavbarOptionsSupported(true);
        if (this.navigationBar.isNavbarOptionsSupported()) {
            this.navigationBar.setFolderList(folders);
        } else {
            this.navigationBar.setFolderList(folders);
        }
    }

    public QuickViewer getQuickViewer() {
        if (this.quickViewer == null) {
            this.quickViewer = new QuickViewer(this.getController(), this);
            logger.debug((Object)" QuickViewer created");
            this.setFocusTraversalPolicy(new FocusTraversalPolicyDecorator(this.quickViewer.getFocusPolicy()){

                public Component getDefaultComponent(Container aContainer) {
                    if (!GWMainAppFrame.this.itemListView.isDead()) {
                        return GWMainAppFrame.this.itemListView.getComponent();
                    }
                    return super.getDefaultComponent(aContainer);
                }

                public Component getInitialComponent(Window window) {
                    if (!GWMainAppFrame.this.itemListView.isDead()) {
                        return GWMainAppFrame.this.itemListView.getComponent();
                    }
                    return super.getInitialComponent(window);
                }
            });
            this.quickViewer.setBorder(BorderFactory.createEmptyBorder());
            WindowFocusOwnerChangeListener propertyChangeListener = new WindowFocusOwnerChangeListener(this);
            ControlsUtils.getListenerManager(this.getController()).addListener(KeyboardFocusManager.getCurrentKeyboardFocusManager(), propertyChangeListener, ListenerType.PROPERTY_CHANGE_LISTENER);
        }
        return this.quickViewer;
    }

    boolean isQuickViewerInited() {
        return this.quickViewer != null;
    }

    public String getSelectedTextFromItemViewer() {
        if (this.isShowQuickViewer() && this.isQuickViewerInited()) {
            return this.quickViewer.getSelectedText();
        }
        return null;
    }

    private List<AbstractFolder> retrieveFolders() {
        List<AbstractFolder> res = new ArrayList<AbstractFolder>();
        AbstractFolder root = (AbstractFolder)((DefaultMutableTreeNode)this.tree.getModel().getRoot()).getUserObject();
        res = GWMainAppFrame.addSubFolders(root, res);
        return res;
    }

    public void updateNumberOfUnreadItem() {
        try {
            AbstractFolder mailBoxFolder = GWCommandManager.getInstance(this.userGuid).getMailboxFolder();
            this.numberOfUnreadItem = mailBoxFolder.getDisplayCount();
        }
        catch (GWCommandException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
    }

    private static List<AbstractFolder> addSubFolders(AbstractFolder f, List<AbstractFolder> l) {
        if (l == null) {
            return null;
        }
        l.add(f);
        List<AbstractFolder> childFolders = f.getChildFolders();
        if (childFolders != null) {
            int n = childFolders.size();
            for (int i = 0; i < n; ++i) {
                AbstractFolder folder = childFolders.get(i);
                l = GWMainAppFrame.addSubFolders(folder, l);
            }
        }
        return l;
    }

    @Override
    protected Dimension getFrameSize() {
        int h = ApplicationOptions.getInstance().getInteger(this.optionFrameName + '.' + "WIN_HEIGHT", 590);
        int w = ApplicationOptions.getInstance().getInteger(this.optionFrameName + '.' + "WIN_WIDTH", 820);
        return new Dimension(w, h);
    }

    private void buildUI() {
        this.navigationBar = new NavBarPanel((GWMainAppFrameActionList)this.appActionList);
        this.headerPopupMenu = new HeaderPopupMenu(this.appActionList);
        this.miniToolBar = new ItemListMiniToolBar((ActionList)this.getController());
        this.miniToolBar.addComponentListener(new MiniToolBarComponentListener());
        this.toolBarNavBarPanel = new GWToolBarPanel();
        this.quickViewerPanel = new JPanel();
        this.quickViewerPanel.setLayout(new BorderLayout());
        this.quickViewerPanel.setBorder(BorderFactory.createEmptyBorder());
        this.tablePanel = new OrientablePanel(new CardLayout());
        this.tablePanel.setMinimumSize(new Dimension(0, 0));
        this.tablePanel.setBorder(BorderFactory.createEmptyBorder());
        this.buildTableHeader();
        this.tablePanelHolder = new JPanel(new BorderLayout());
        this.tablePanelHolder.setBorder(BorderFactory.createEmptyBorder());
        this.tablePanelHolder.add((Component)this.tableHeaderPanel, "North");
        this.tablePanelHolder.add((Component)this.tablePanel, "Center");
        this.multiPanelView = new MultiPanelView(this.getController());
        this.tablePanel.add((Component)this.multiPanelView, MULTI_PANEL_VIEW);
        this.itemListView = new ItemListViewPanel(this.getController());
        this.tablePanel.add((Component)this.itemListView.getComponent(), ITEM_LIST_VIEW);
        this.buildTreeHeader();
        this.tree = new MainGWFoldersTree(this.getController(), this.getUserGuid());
        this.tree.setBorder(BorderFactory.createEmptyBorder());
        this.treePanel = new OrientablePanel();
        this.treePanel.setLayout(new BorderLayout());
        this.treePanel.setBorder(BorderFactory.createEmptyBorder());
        this.treePanel.add((Component)this.treeHeaderPanel, "North");
        this.treePanel.addMouseListener(AbstractActionsPopupMenu.createMenuMouseListener(this.headerPopupMenu));
        this.scrollPaneTree = new ColoredScrollPane(this.tree);
        this.scrollPaneTree.setBorder(Borders.getEmptyTextComponentBorder(false));
        this.treePanel.add((Component)this.scrollPaneTree, "Center");
        this.mainPanel = new GWMainAppFrameMainPanel(this, this.tablePanelHolder, this.treePanel);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder());
        this.centeredContentPanel.add((Component)this.mainPanel, "Center");
        this.setGWMenuBar(this.getMainMenu());
        this.initToolbars();
        ((JPanel)this.getContentPane()).updateUI();
    }

    private void buildTableHeader() {
        this.tableHeaderPanel = new SkinnablePanel(new GridBagLayout());
        ControlsUtils.prepareHeaderPanel(this.tableHeaderPanel);
        GridBagConstraints c = new GridBagConstraints();
        this.folderLabel = new HeaderLabel();
        this.folderLabel.setPreferredSize(new Dimension(72, 18));
        this.folderLabel.setName("GWMainAppFrame_folderLabel");
        this.tableStorageSwitcher = new StorageSwitcher((ActionList)this.getController());
        this.tableStorageSwitcher.setName("TableStorageSwitcher");
        this.tableStorageSwitcher.setTextVisible(false);
        this.headerRigidArea = (JComponent)Box.createRigidArea(new Dimension(10, 1));
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.tableHeaderPanel.add((Component)this.headerRigidArea, c);
        ++c.gridx;
        c.weighty = 1.0;
        c.fill = 3;
        this.tableHeaderPanel.add((Component)this.tableStorageSwitcher, c);
        ++c.gridx;
        this.tableHeaderPanel.add((Component)this.folderLabel, c);
        ++c.gridx;
        c.weightx = 0.5;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 21;
        this.tableHeaderPanel.add((Component)this.miniToolBar, c);
        ++c.gridx;
        c.weightx = 0.2;
        c.fill = 1;
        this.tableHeaderPanel.add(Box.createHorizontalGlue(), c);
        ++c.gridx;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        this.pnlQuick = new QuickFilterPanel(this.appActionList);
        this.tableHeaderPanel.add((Component)this.pnlQuick, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.tableHeaderPanel.add(Box.createHorizontalStrut(10), c);
        this.tableHeaderPanel.addMouseListener(AbstractActionsPopupMenu.createMenuMouseListener(this.headerPopupMenu));
        this.folderLabel.setDropTarget(new DropTarget(this.folderLabel, 3, new FolderLabelDropTargetListener(this.folderLabel, this)));
        this.tableHeaderPanel.setDropTarget(new DropTarget(this.tableHeaderPanel, 3, new HeaderPanelDropTargetListener(this.folderLabel, this.tableHeaderPanel)));
    }

    private void updateHeaderHeight() {
        this.updateHeaderHeight(true);
    }

    public void updateHeaderHeight(boolean fixFontSize) {
        Dimension dFolderLabel = this.folderLabel.getPreferredSize();
        Dimension dTreeStorage = this.treeStorageSwitcher.getPreferredSize();
        Dimension dTableStorage = this.tableStorageSwitcher.getPreferredSize();
        boolean folderTreeVisible = EngineCommandManager.getInstance(this.userGuid).getAppearanceSettings().isFolderTreeVisible();
        if (folderTreeVisible) {
            int height = Math.max(dTreeStorage.height, dTableStorage.height);
            height = Math.max(height, dFolderLabel.height);
            this.headerRigidArea.setSize(10, height += 10);
        } else {
            int height = this.tableHeaderPanel.getSize().height;
            this.headerRigidArea.setSize(10, height);
        }
    }

    private void buildTreeHeader() {
        this.treeHeaderPanel = new SkinnablePanel(new GridBagLayout());
        ControlsUtils.prepareHeaderPanel(this.treeHeaderPanel);
        this.treeHeaderPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.treeStorageSwitcher = new StorageSwitcher((ActionList)this.getController());
        this.treeStorageSwitcher.setName("TreeStorageSwitcher");
        SkinnablePanel c = this.treeHeaderPanel;
        c.setLayout(new BoxLayout(c, 2));
        this.treeHeaderPanel.add(Box.createHorizontalStrut(10));
        this.treeHeaderPanel.add(this.treeStorageSwitcher);
    }

    public void updateTitle() {
        String title = "";
        String notificationsPrefix = "";
        if (!OS.isMacOS() && !OS.isTrayIconSupported() && this.numberOfUnreadItem > 0) {
            notificationsPrefix = "[" + this.numberOfUnreadItem + "] ";
        }
        if (GWCommandManager.getInstance(this.getUserGuid()).isProxyDataStore()) {
            title = GWCommandManager.getInstance(this.getUserGuid()).getProxyUserName() + " - ";
        } else if (GWCommandManager.getInstance(this.getUserGuid()).isArchive()) {
            title = '(' + StringResources.ARCHIVE + ')' + " - ";
        } else if (GWCommandManager.getInstance(this.getUserGuid()).isBackupDB()) {
            title = '(' + StringResources.BACKUP + ')' + " - ";
        }
        title = title + basicTitle;
        if (this.folder != null) {
            title = title + "  -  " + this.folder.getName();
        }
        this.frameName = title;
        title = notificationsPrefix + title;
        this.setTitle(title);
    }

    private void checkAndCorrectEmptyPanels(AbstractFolder folder) {
        assert (folder != null);
        assert (folder.getDisplaySettings().getViewMode() == 8);
        IFolderDisplaySettings displaySettings = folder.getDisplaySettings();
        if (displaySettings.getPanelCount() <= 0) {
            logger.warn((Object)"PANELS view mode, but no panel > proposing to create some panels.");
            boolean panelsCorrected = CustomizePanelsDialog.show(this, this.getController(), folder.getNativeFolder(), displaySettings, true);
            logger.debug((Object)("panelsCorrected = " + panelsCorrected));
            if (!panelsCorrected) {
                logger.debug((Object)"changing view mode to details");
                folder.getDisplaySettings().setViewMode(1);
            }
        }
    }

    public void setFolder(AbstractFolder theFolder) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setting folder: " + this.folder + " > " + theFolder + (theFolder == null ? "" : "(ID: " + theFolder.getID() + ')')));
            logger.debug((Object)("ID: " + (this.folder == null ? "NONE" : this.folder.getID()) + " > " + (theFolder == null ? "NONE" : theFolder.getID())));
            logger.debug((Object)("view mode: " + (this.folder == null ? "NONE" : Integer.valueOf(this.folder.getDisplaySettings().getViewMode())) + " > " + (theFolder == null ? "NONE" : Integer.valueOf(theFolder.getDisplaySettings().getViewMode()))));
        }
        MessageUtils.showBusyCursor(true);
        ((GWMainAppFrameActionList)this.getController()).processCommand(new Command(2040, theFolder));
        if (theFolder != null && theFolder.getDisplaySettings().getViewMode() == 8) {
            this.checkAndCorrectEmptyPanels(theFolder);
        }
        if (this.folder != null && this.isMultiPanelView() && (theFolder == null || theFolder.getDisplaySettings().getViewMode() != 8)) {
            this.multiPanelView.cleanUpViews(true);
        }
        Filter filter = this.pnlQuick.getFilter();
        if (this.folder != null && theFolder != null && !this.folder.getNativeFolder().equals(theFolder.getNativeFolder()) || this.folder == null && theFolder != null) {
            this.folder = theFolder;
            this.pnlQuick.setFolder(this.folder);
            filter = this.pnlQuick.getFilter();
            this.changeFolderLabel();
            this.updateTitle();
            this.mainPanel.updatePanelForFolder(theFolder);
        }
        if (this.folder.getDisplaySettings().getViewMode() == 8) {
            this.itemListView.dispose();
            this.itemListView.setActivated(false);
            this.multiPanelView.setFolder(this.folder);
            this.viewState = 3;
            ((CardLayout)this.tablePanel.getLayout()).show(this.tablePanel, MULTI_PANEL_VIEW);
        } else {
            this.itemListView.setActivated(true);
            this.itemListView.setData(this.folder, this.folder.getDisplaySettings().asViewDisplaySettings(), filter);
            this.viewState = 4;
            ((CardLayout)this.tablePanel.getLayout()).show(this.tablePanel, ITEM_LIST_VIEW);
            this.itemListView.refresh();
        }
        this.navigationBar.selectFolder(this.folder);
        this.markQuickViewerBtnState();
        this.tree.setEditable(this.folder.canRename());
        MessageUtils.showBusyCursor(false);
    }

    public void markQuickViewerBtnState() {
        boolean bVisible = this.mainPanel.isQuickViewerVisible();
        ActionQuickViewer action = (ActionQuickViewer)((GWMainAppFrameActionList)this.appActionList).getAction(ActionKey.QUICKVIEWER);
        action.setSelected(bVisible);
    }

    public void setTotalItemsCount(int theItemsCount) {
        this.panStatusPanel.setTotalItemsCount(theItemsCount);
    }

    private void changeFolderLabel() {
        Filter filter = this.pnlQuick.getFilter();
        this.folderLabel.setFolder(this.folder);
        this.folderLabel.setFiltered(filter != null && !filter.isEmpty());
    }

    public boolean isMultiPanelView() {
        return this.viewState == 3;
    }

    public void setQuickViewerPosition(QuickViewerLocation location) {
        this.mainPanel.setQuickViewerLocation(location);
        boolean right = location == QuickViewerLocation.RIGHT;
        ((GWMainAppFrameActionList)this.getController()).getAction(ActionKey.QUICKVIEWER_AT_BOTTOM).setSelected(!right);
        ((GWMainAppFrameActionList)this.getController()).getAction(ActionKey.QUICKVIEWER_AT_RIGHT).setSelected(right);
    }

    private void initToolbars() {
        this.toolbarsPanel = new GWMainAppFrameToolBarsPanelsPane(this);
        this.toolBarNavBarPanel.add((Component)this.toolbarsPanel, "Center");
        this.setToolBarPanel(this.toolBarNavBarPanel, "North");
        this.showToolbar();
    }

    @Override
    public void showToolbar() {
        this.toolbarsPanel.updateToolbars();
        this.miniToolBar.setVisible(!this.isMainToolBarVisible());
        this.updateHeaderHeight();
    }

    private boolean isMainToolBarVisible() {
        return GWCommandManager.getInstance(this.userGuid).getAppearanceSettings().isMainToolBarVisible();
    }

    public void setMainToolbarVisible(boolean visible) {
        this.showToolbar();
    }

    public void setNavBarVisible(boolean visible) {
        this.navigationBar.setVisible(visible);
    }

    public void setFolderListVisible(boolean folderListVisible) {
        this.navigationBar.setFolderListVisible(folderListVisible);
        this.mainPanel.setFolderTreeVisible(folderListVisible);
        this.rebuildHeader(folderListVisible);
        this.updateHeaderHeight();
    }

    private void rebuildHeader(boolean folderListVisible) {
        SkinnablePanel pnlHeader = this.tableHeaderPanel;
        if (pnlHeader.getComponentCount() > 0) {
            if (!folderListVisible) {
                this.folderLabel.setAnchorComponent(this.tablePanel);
                this.folderLabel.setEnablePopupFolderList(true);
                if (this.scrollPaneTree.getSize().height == 0) {
                    logger.debug((Object)"scrollPane with tree has zero-height > setting its size");
                    int loadedTreeWidth = ApplicationOptions.getInstance().getInteger("FOLDERLIST_SPLITPOS", 150);
                    if (loadedTreeWidth < 50) {
                        loadedTreeWidth = 150;
                    }
                    this.scrollPaneTree.setSize(new Dimension(loadedTreeWidth, this.tablePanelHolder.getSize().height));
                }
                this.folderLabel.setPopupContents(this.scrollPaneTree);
                this.folderLabel.setTree(this.tree);
            } else {
                this.treePanel.add((Component)this.scrollPaneTree, "Center");
                this.folderLabel.setEnablePopupFolderList(false);
            }
        }
        this.treeStorageSwitcher.setVisible(folderListVisible);
        this.tableStorageSwitcher.setVisible(!folderListVisible);
    }

    public void hideFoldersTreePopup() {
        this.folderLabel.hidePopup();
    }

    public void showFoldersTreePopup() {
        this.folderLabel.showPopup();
    }

    public void setFilter(Filter filter) {
        if (this.folderLabel != null && this.folder != null) {
            this.folderLabel.setFiltered(filter != null && !filter.isEmpty());
        }
    }

    @Override
    public Filter getFilter() {
        return this.pnlQuick.getFilter();
    }

    private GWMenuBar getMainMenu() {
        if (this.getGWMenuBar() == null) {
            return new GWApplicationFrameMenuBar((ApplicationFrameActionList)this.getController());
        }
        return this.getGWMenuBar();
    }

    public void setQuickViewerVisible(boolean visible) {
        this.mainPanel.setQuickViewerVisible(visible);
    }

    public AbstractFolder getFolder() {
        return this.folder;
    }

    public void setLongFolderTree(boolean longFolderTree) {
        this.mainPanel.setLongFolderTree(longFolderTree);
    }

    @Override
    protected void afterShow() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doAfterShow();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        GWMainAppFrame.this.doAfterShow();
                    }
                });
            }
            catch (InterruptedException e) {
                logger.error((Object)e, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        super.afterShow();
    }

    void beforeControllerIsReleased() {
        this.multiPanelView.cleanUpViews(false);
    }

    private void doAfterShow() {
        this.tree.refreshTree(false);
        Command command = new Command(1080);
        ((GWMainAppFrameActionList)this.appActionList).processCommand(command);
    }

    public boolean isShowQuickViewer() {
        return this.mainPanel.isQuickViewerVisible();
    }

    public boolean isVisibleFolderListTree() {
        return this.mainPanel.isFolderTreeVisible();
    }

    @Override
    public void release() {
        super.release();
        this.tablePanelHolder = null;
        this.mainPanel = null;
        this.tablePanel = null;
        this.treePanel = null;
        this.tree = null;
        if (this.quickViewerPanel != null) {
            this.quickViewerPanel.removeAll();
            this.quickViewerPanel = null;
        }
        if (this.quickViewer != null) {
            this.quickViewer.release();
            this.quickViewer = null;
        }
        this.tableHeaderPanel = null;
        this.treeHeaderPanel = null;
        this.pnlQuick = null;
        this.folderLabel = null;
        this.folder = null;
        this.navigationBar = null;
    }

    public MultiPanelView getMultiPanelView() {
        return this.multiPanelView;
    }

    public MainGWFoldersTree getFoldersTree() {
        return this.tree;
    }

    private int getMinHeaderPanelHeight() {
        Dimension dFolderLabel = this.folderLabel.getPreferredSize();
        Dimension dTreeStorage = this.treeStorageSwitcher.getPreferredSize();
        Dimension dTableStorage = this.tableStorageSwitcher.getPreferredSize();
        int height = Math.max(dTreeStorage.height, dTableStorage.height);
        height = Math.max(height, dFolderLabel.height);
        return height += 10;
    }

    @Override
    public ISelectedItemsInfo getSelectedItemsInfo() {
        return this.selectedItemsInfo;
    }

    void setSelectedItemsInfo(ISelectedItemsInfo selectedItemsInfo) {
        this.selectedItemsInfo = selectedItemsInfo;
    }

    @Override
    public void setUserGuid(String userGuid) {
        super.setUserGuid(userGuid);
        this.updateNumberOfUnreadItem();
    }

    public void repaintDocIconInMacOS() {
        if (OS.isMacOS()) {
            int unReadItems = 0;
            try {
                GWCommandManager gwCommandManager = GWCommandManager.getInstance(EngineCommandManager.getUserGuid());
                unReadItems = gwCommandManager.getMailboxFolder().getDisplayCount();
            }
            catch (GWCommandException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
            if (OS.getJavaVersionMajor() == 1 && OS.getJavaVersionMinor() >= 6 || OS.getJavaVersionMajor() > 1) {
                try {
                    ApplicationWrapper.getApplication().setDockIconBadge(unReadItems > 0 ? String.valueOf(unReadItems) : "");
                }
                catch (ClassNotFoundException e) {
                    logger.error((Object)e);
                }
            } else {
                DefaultApplication application = new DefaultApplication();
                if (GW_DOCK_ICON == null) {
                    GW_DOCK_ICON = application.getApplicationIconImage();
                }
                BufferedImage newIcon = new BufferedImage(GW_DOCK_ICON.getWidth(), GW_DOCK_ICON.getHeight(), 2);
                Graphics2D graphics = (Graphics2D)newIcon.getGraphics();
                graphics.drawImage((Image)GW_DOCK_ICON, 0, 0, null);
                int iconWidth = GW_DOCK_ICON.getWidth();
                int iconHeight = GW_DOCK_ICON.getHeight();
                graphics.setColor(Color.RED);
                if (unReadItems > 0) {
                    String sNumber = Integer.toString(unReadItems);
                    if (unReadItems < 100) {
                        graphics.fillOval(iconWidth / 2, 0, iconWidth / 2, iconHeight / 2);
                        graphics.setColor(Color.WHITE);
                        graphics.setFont(new Font(graphics.getFont().getName(), 1, iconHeight / 3));
                        int length = SwingUtilities.computeStringWidth(graphics.getFontMetrics(), sNumber);
                        graphics.drawString(sNumber, iconWidth * 3 / 4 - length / 2, iconHeight * 3 / 8);
                    } else {
                        graphics.fillOval(iconWidth / 3, 0, iconWidth * 2 / 3, iconHeight / 2);
                        graphics.setColor(Color.WHITE);
                        graphics.setFont(new Font(graphics.getFont().getName(), 1, iconHeight / 4));
                        int length = SwingUtilities.computeStringWidth(graphics.getFontMetrics(), sNumber);
                        graphics.drawString(sNumber, iconWidth * 2 / 3 - length / 2, iconHeight / 3);
                    }
                }
                graphics.dispose();
                application.setApplicationIconImage(newIcon);
            }
        }
    }

    void refreshQueryStatus(boolean isSearching) {
        this.setCursor(isSearching ? Cursor.getPredefinedCursor(3) : null);
    }

    private class MiniToolBarComponentListener
    extends ComponentAdapter {
        private MiniToolBarComponentListener() {
        }

        public void componentResized(ComponentEvent e) {
            int height = e.getComponent().getPreferredSize().height;
            this.updateTreeHeaderHeight(height += 10);
            this.updateTableHeaderHeight(height);
        }

        public void componentHidden(ComponentEvent e) {
            int height = GWMainAppFrame.this.getMinHeaderPanelHeight();
            this.updateTreeHeaderHeight(height);
            this.updateTableHeaderHeight(height);
        }

        public void componentShown(ComponentEvent e) {
            int height = e.getComponent().getPreferredSize().height;
            this.updateTreeHeaderHeight(height += 10);
            this.updateTableHeaderHeight(height);
        }

        private void updateTreeHeaderHeight(int height) {
            if (GWMainAppFrame.this.treeHeaderPanel.getHeight() != height) {
                logger.debug((Object)("tree height > " + height));
                Dimension treeHeaderSize = GWMainAppFrame.this.treeHeaderPanel.getPreferredSize();
                treeHeaderSize.height = height;
                GWMainAppFrame.this.treeHeaderPanel.setPreferredSize(treeHeaderSize);
                GWMainAppFrame.this.treeHeaderPanel.revalidate();
            }
        }

        private void updateTableHeaderHeight(int height) {
            if (GWMainAppFrame.this.tableHeaderPanel.getHeight() != height) {
                logger.debug((Object)("tree height > " + height));
                Dimension treeHeaderSize = GWMainAppFrame.this.tableHeaderPanel.getPreferredSize();
                treeHeaderSize.height = height;
                GWMainAppFrame.this.tableHeaderPanel.setPreferredSize(treeHeaderSize);
                GWMainAppFrame.this.tableHeaderPanel.revalidate();
            }
        }
    }
}

