/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application;

import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.ExTableUI;
import com.novell.gw.jclient.application.controls.orientable.OrientableTable;
import com.novell.gw.jclient.application.controls.orientable.OrientableTableCellRenderer;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class GWTable
extends OrientableTable {
    public static final int TABLE_DEFAULT_HEIGHT = PLAFChanger.getFontSize() + 8;
    private static Logger logger = Logger.getLogger(GWTable.class);
    private EventListenerList doubleClickedRowEventListeners = new EventListenerList();

    public GWTable() {
        this.initUI();
    }

    public GWTable(TableModel dm) {
        super(dm);
        this.initUI();
    }

    public GWTable(Object[][] rowData, Object[] columNames) {
        super(rowData, columNames);
        this.initUI();
    }

    protected void initUI() {
        this.setUI(new GWTableUI());
        this.setDefaultRenderer(Object.class, new OrientableTableCellRenderer());
        UIUtils.initTableFocusTraversalKeys(this);
        if (this.getTableHeader() != null) {
            this.getTableHeader().setPreferredSize(new Dimension(this.getTableHeader().getPreferredSize().width, TABLE_DEFAULT_HEIGHT));
        }
    }

    private void fireRowDoubleClicked(int rowIndex) {
        if (this.doubleClickedRowEventListeners.getListenerCount(DoubleClickedRowListener.class) > 0) {
            DoubleClickedRowListener[] listeners;
            DoubleClickedRowEvent event = new DoubleClickedRowEvent(this, rowIndex);
            for (DoubleClickedRowListener listener : listeners = (DoubleClickedRowListener[])this.doubleClickedRowEventListeners.getListeners(DoubleClickedRowListener.class)) {
                listener.tableRowDoubleClicked(event);
            }
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        int rowIndex;
        super.processMouseEvent(e);
        if (OS.isDoubleClick(e) && (rowIndex = this.rowAtPoint(e.getPoint())) >= 0) {
            this.fireRowDoubleClicked(rowIndex);
        }
    }

    public void addDoubleClickedRowListener(DoubleClickedRowListener listener) {
        this.doubleClickedRowEventListeners.add(DoubleClickedRowListener.class, listener);
    }

    public void removeDoubleClickedRowListener(DoubleClickedRowListener listener) {
        this.doubleClickedRowEventListeners.remove(DoubleClickedRowListener.class, listener);
    }

    public void tableMouseMove(MouseEvent e) {
    }

    public class DoubleClickedRowEvent
    extends EventObject {
        private final int rowIndex;

        public DoubleClickedRowEvent(Object source, int theRowIndex) {
            super(source);
            this.rowIndex = theRowIndex;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }
    }

    public static interface DoubleClickedRowListener
    extends EventListener {
        public void tableRowDoubleClicked(DoubleClickedRowEvent var1);
    }

    private class GWTableUI
    extends ExTableUI {
        private GWTableUI() {
        }

        protected MouseInputListener createMouseInputListener() {
            return new TUMouseListener();
        }

        private class TUMouseListener
        extends MyMouseInputHandler {
            private TUMouseListener() {
            }

            private boolean isSelectionAlowed(MouseEvent e) {
                boolean rowSelected = GWTable.this.isRowSelected(GWTable.this.rowAtPoint(e.getPoint()));
                boolean rv = OS.isMacOS() ? e.isShiftDown() || e.isMetaDown() || rowSelected : e.isShiftDown() || e.isControlDown() || rowSelected;
                return rv;
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
            }

            public void mouseDragged(MouseEvent e) {
                if (this.isSelectionAlowed(e)) {
                    // empty if block
                }
            }
        }
    }

    public class MyMouseInputHandler
    implements MouseInputListener {
        private Component dispatchComponent;
        private boolean selectedOnPress;
        private boolean pressedInSelection = false;

        public void mouseClicked(MouseEvent e) {
        }

        private void setDispatchComponent(MouseEvent e) {
            Component editorComponent = GWTable.this.getEditorComponent();
            Point p = e.getPoint();
            Point p2 = SwingUtilities.convertPoint(GWTable.this, p, editorComponent);
            this.dispatchComponent = SwingUtilities.getDeepestComponentAt(editorComponent, p2.x, p2.y);
        }

        private boolean repostEvent(MouseEvent e) {
            if (this.dispatchComponent == null || !GWTable.this.isEditing()) {
                return false;
            }
            MouseEvent e2 = SwingUtilities.convertMouseEvent(GWTable.this, e, this.dispatchComponent);
            this.dispatchComponent.dispatchEvent(e2);
            return true;
        }

        private void setValueIsAdjusting(boolean flag) {
            GWTable.this.getSelectionModel().setValueIsAdjusting(flag);
            GWTable.this.getColumnModel().getSelectionModel().setValueIsAdjusting(flag);
        }

        private boolean shouldIgnore(MouseEvent e) {
            return e.isConsumed() || !OS.isLeftMouseButton(e) || !GWTable.this.isEnabled();
        }

        public void mousePressed(MouseEvent e) {
            if (e.isConsumed()) {
                this.selectedOnPress = false;
                return;
            }
            this.selectedOnPress = true;
            this.adjustFocusAndSelection(e);
        }

        void adjustFocusAndSelection(MouseEvent e) {
            if (this.shouldIgnore(e)) {
                return;
            }
            Point p = e.getPoint();
            int row = GWTable.this.rowAtPoint(p);
            int column = GWTable.this.columnAtPoint(p);
            if (column == -1 || row == -1) {
                return;
            }
            if (GWTable.this.editCellAt(row, column, e)) {
                this.setDispatchComponent(e);
                this.repostEvent(e);
            } else if (GWTable.this.isRequestFocusEnabled()) {
                GWTable.this.requestFocus();
            }
            TableCellEditor editor = GWTable.this.getCellEditor();
            if (editor == null || editor.shouldSelectCell(e)) {
                boolean selectionKey;
                boolean adjusting = e.getID() == 501;
                this.setValueIsAdjusting(adjusting);
                int selectedRow = GWTable.this.rowAtPoint(e.getPoint());
                if (OS.isMacOS()) {
                    selectionKey = e.isShiftDown() || e.isMetaDown();
                } else {
                    boolean bl = selectionKey = e.isShiftDown() || e.isControlDown();
                }
                if (selectedRow >= 0 && this.inSelection(selectedRow) && !e.isPopupTrigger() && !selectionKey && !this.pressedInSelection) {
                    this.pressedInSelection = true;
                    this.selectedOnPress = false;
                } else {
                    this.pressedInSelection = false;
                    this.doChangeSelection(row, column, e);
                }
            }
        }

        private void doChangeSelection(int row, int column, MouseEvent e) {
            if (OS.isMacOS()) {
                GWTable.this.changeSelection(row, column, e.isMetaDown(), e.isShiftDown());
            } else {
                GWTable.this.changeSelection(row, column, e.isControlDown(), e.isShiftDown());
            }
        }

        private boolean inSelection(int theSelectedRow) {
            GWTable table = GWTable.this;
            int[] rows = table.getSelectedRows();
            for (int i = 0; i < rows.length; ++i) {
                if (theSelectedRow != rows[i]) continue;
                return true;
            }
            return false;
        }

        public void mouseReleased(MouseEvent e) {
            if (this.selectedOnPress) {
                if (this.shouldIgnore(e)) {
                    return;
                }
                this.repostEvent(e);
                this.dispatchComponent = null;
                this.setValueIsAdjusting(false);
            } else {
                this.adjustFocusAndSelection(e);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            GWTable.this.tableMouseMove(e);
        }

        public void mouseDragged(MouseEvent e) {
            if (this.shouldIgnore(e)) {
                return;
            }
            this.repostEvent(e);
            TableCellEditor editor = GWTable.this.getCellEditor();
            if (editor == null || editor.shouldSelectCell(e)) {
                Point p = e.getPoint();
                int row = GWTable.this.rowAtPoint(p);
                int column = GWTable.this.columnAtPoint(p);
                if (column == -1 || row == -1) {
                    return;
                }
                GWTable.this.changeSelection(row, column, false, true);
            }
        }
    }
}

