/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.components.ButtonList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.commands.AttributeKey;
import com.novell.gw.jclient.application.frames.compose.FrameCompose;
import com.novell.gw.jclient.application.interfaces.ISelectedItemsInfo;
import com.novell.gw.jclient.application.options.OptionManager;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

public abstract class AbstractActionHTMLAndPlainText
extends AppAction {
    private ButtonList buttons = new ButtonList(false);

    public AbstractActionHTMLAndPlainText(ActionList actionList, ActionKey actionKey, String name, Icon icon) {
        super(actionList, actionKey, name, icon);
        this.buttons.setEnabled(!OptionManager.getInstance().getTextOption().isHTMLDisallowed());
        this.setType(AppAction.ActionType.RADIO);
    }

    public JMenuItem getMenuItem() {
        JMenuItem item = OS.createMenuItem(this);
        this.buttons.add(item);
        return item;
    }

    public JComponent getToolBarComponent() {
        AbstractButton button = (AbstractButton)super.getToolBarComponent();
        this.buttons.add(button);
        return button;
    }

    public void setSelected(boolean b) {
        super.setSelected(b);
        this.buttons.setSelected(b);
    }

    public void setEnabled(boolean newValue) {
        super.setEnabled(newValue);
        this.buttons.setEnabled(newValue);
    }

    public boolean showWithText() {
        return false;
    }

    protected void registerListeners() {
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 20, new GWITEM_SELECTED_Listener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 2010, new REFRESH_HTML_PLAIN_MODE_Listener()));
    }

    protected abstract void handle_GWITEM_SELECTED(AppEvent var1);

    protected abstract void handle_REFRESH_HTML_PLAIN_MODE(AppEvent var1);

    private class REFRESH_HTML_PLAIN_MODE_Listener
    extends AppEventListener {
        private REFRESH_HTML_PLAIN_MODE_Listener() {
        }

        public void handle(AppEvent event) {
            if (AbstractActionHTMLAndPlainText.this.getActionList().getMVCView().equals(event.getAttribute((Object)AttributeKey.SOURCE))) {
                AbstractActionHTMLAndPlainText.this.handle_REFRESH_HTML_PLAIN_MODE(event);
            }
        }
    }

    private class GWITEM_SELECTED_Listener
    extends AppEventListener {
        private GWITEM_SELECTED_Listener() {
        }

        public void handle(AppEvent event) {
            if (event.getData() instanceof ISelectedItemsInfo && AbstractActionHTMLAndPlainText.this.getActionList().getOwnerComponent() instanceof FrameCompose) {
                AbstractActionHTMLAndPlainText.this.handle_GWITEM_SELECTED(event);
            }
        }
    }
}

