/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.Command;
import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.ab.IGroupContact;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.StorageMode;
import com.novell.gw.jclient.application.frames.compose.FrameCompose;
import com.novell.gw.jclient.application.frames.compose.FrameComposeActionList;
import com.novell.gw.jclient.application.interfaces.ISelectedContactsInfo;
import com.novell.gw.jclient.application.resources.StringResources;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public abstract class AbstractAddressBookAction
extends AppAction {
    protected List<IRecipient> allRecipients = new ArrayList<IRecipient>();
    protected List<IRecipient> validRecipients = new ArrayList<IRecipient>();
    protected boolean isSendingFromAddressBook;

    protected AbstractAddressBookAction(ActionList actionList, ActionKey actionKey, String name) {
        super(actionList, actionKey, name);
        this.setEnabled(this.checkAccess());
    }

    protected AbstractAddressBookAction(ActionList actionList, ActionKey actionKey, String name, Icon icon) {
        super(actionList, actionKey, name, icon);
        this.setEnabled(this.checkAccess());
    }

    protected boolean validateRecipients() {
        this.validRecipients.clear();
        int nSize = this.allRecipients.size();
        for (int i = 0; i < nSize; ++i) {
            IAddressable addressable = this.allRecipients.get(i).getAddressable();
            if (!(addressable instanceof IGroupContact) && addressable.getEmailAddress().length() == 0) continue;
            this.validRecipients.add(this.allRecipients.get(i));
        }
        int invalidRecipientsCount = this.allRecipients.size() - this.validRecipients.size();
        if (invalidRecipientsCount > 0) {
            String component = StringResources.formatString(StringResources.IN_ATTEMPTING_TO_USE, Integer.toString(invalidRecipientsCount));
            int result = JOptionPane.showConfirmDialog(this.getActionList().getOwnerComponent(), component, StringResources.ADDRESS_BOOK_K_QUESTION, 2);
            return result == 0;
        }
        return true;
    }

    public boolean isSendingFromAddressBook() {
        return this.isSendingFromAddressBook;
    }

    public void setSendingFromAddressBook(boolean sendingFromAddressBook) {
        this.isSendingFromAddressBook = sendingFromAddressBook;
    }

    void sendRecipients(FrameCompose theFrameCompose) {
        if (!this.validRecipients.isEmpty()) {
            Command command = new Command(100, new ArrayList<IRecipient>(this.validRecipients));
            ((FrameComposeActionList)theFrameCompose.getController()).processCommand(command);
        }
    }

    protected abstract boolean checkAccess();

    protected void registerListeners() {
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 1930, new CONTACT_ITEM_SELECTED_Listener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 240, new ADDRESS_BOOK_ITEMS_SELECTED_Listener()));
        ClearListener listener = new ClearListener();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 360, listener));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 270, listener));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 800, new StoreModeChangedListener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 750, new PROXY_DATA_STORE_INSTALLED_Listener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 10, new FolderSelectedListener()));
    }

    private class ADDRESS_BOOK_ITEMS_SELECTED_Listener
    extends AppEventListener {
        private ADDRESS_BOOK_ITEMS_SELECTED_Listener() {
        }

        public void handle(AppEvent event) {
            ISelectedContactsInfo contactsInfo;
            Object data = event.getData();
            if (data instanceof ISelectedContactsInfo && (contactsInfo = (ISelectedContactsInfo)data).hasContacts()) {
                AbstractAddressBookAction.this.allRecipients = new ArrayList<IRecipient>();
                for (IContact contact : contactsInfo.getContacts()) {
                    AbstractAddressBookAction.this.allRecipients.add(APIAbWrapperManager.createRecipient(contact));
                }
            }
        }
    }

    private class FolderSelectedListener
    extends AppEventListener {
        private FolderSelectedListener() {
        }

        public void handle(AppEvent theEvent) {
            AbstractAddressBookAction.this.allRecipients.clear();
            AbstractAddressBookAction.this.validRecipients.clear();
        }
    }

    private class PROXY_DATA_STORE_INSTALLED_Listener
    extends AppEventListener {
        private PROXY_DATA_STORE_INSTALLED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            AbstractAddressBookAction.this.setEnabled(AbstractAddressBookAction.this.checkAccess());
        }
    }

    private class StoreModeChangedListener
    extends AppEventListener {
        private StoreModeChangedListener() {
        }

        public void handle(AppEvent theEvent) {
            StorageMode storeMode = (StorageMode)theEvent.getData();
            AbstractAddressBookAction.this.setEnabled(storeMode.isNormal());
        }
    }

    private class ClearListener
    extends AppEventListener {
        private ClearListener() {
        }

        public void handle(AppEvent theEvent) {
            AbstractAddressBookAction.this.allRecipients.clear();
            AbstractAddressBookAction.this.validRecipients.clear();
        }
    }

    private class CONTACT_ITEM_SELECTED_Listener
    extends AppEventListener {
        private CONTACT_ITEM_SELECTED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            AbstractAddressBookAction.this.allRecipients = (List)theEvent.getData();
        }
    }
}

