/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.novell.gw.jclient.api.enums.ContactType;
import com.novell.gw.jclient.api.interfaces.folder.IContactsFolder;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.StorageMode;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.ContactDetailsDialog;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import com.novell.gw.jclient.bl.om.directory.GroupWiseAddressBook;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.ContactsFolder;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.Icon;

public abstract class AbstractNewABItem
extends AppAction {
    protected ContactType contactType;

    protected AbstractNewABItem(ActionList actionList, ActionKey actionKey, String name, Icon icon) {
        super(actionList, actionKey, name, icon);
        boolean isProxyDataStore = EngineCommandManager.getInstance(ControlsUtils.getUserGuid(actionList)).isProxyDataStore();
        this.setEnabled(!isProxyDataStore);
    }

    protected void performAction(ActionEvent e) {
        AbstractFolder folder;
        MessageUtils.showBusyCursor(true);
        Window parentWindow = (Window)this.getActionList().getMVCView();
        AbstractAddressBook directory = (AbstractAddressBook)this.getMVCModel();
        if (directory == null) {
            directory = EngineCommandManager.getContactsFolderAddressBook();
        }
        if (this.getController().getMVCView() instanceof GWMainAppFrame && (folder = ((GWMainAppFrame)this.getController().getMVCView()).getFolder()) instanceof ContactsFolder) {
            directory = ((ContactsFolder)folder).getAddressBook(EngineCommandManager.getAddressBookManager());
        }
        ContactDetailsDialog dialog = ContactDetailsDialog.createContactDetailsDialog(parentWindow, directory, this.contactType);
        dialog.showMe();
        MessageUtils.showBusyCursor(false);
    }

    protected void registerListeners() {
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(this.getActionList().getLevel(), 360, new DIRECTORY_SELECTED_Listener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 800, new STORE_MODE_CHANGED_Listener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 750, new PROXY_DATA_STORE_INSTALLED_Listener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(this.getActionList().getLevel(), 10, new FOLDER_SELECTED_Listener()));
    }

    private class PROXY_DATA_STORE_INSTALLED_Listener
    extends AppEventListener {
        private PROXY_DATA_STORE_INSTALLED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            AbstractNewABItem.this.setEnabled(false);
        }
    }

    private class STORE_MODE_CHANGED_Listener
    extends AppEventListener {
        private STORE_MODE_CHANGED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            StorageMode storeMode = (StorageMode)theEvent.getData();
            AbstractNewABItem.this.setEnabled(storeMode.isNormal() && AbstractNewABItem.this.getMVCModel() instanceof AbstractAddressBook);
        }
    }

    private class FOLDER_SELECTED_Listener
    extends AppEventListener {
        private FOLDER_SELECTED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            boolean isProxyDataStore = EngineCommandManager.getInstance(ControlsUtils.getUserGuid(AbstractNewABItem.this.getActionList())).isProxyDataStore();
            if (isProxyDataStore) {
                AbstractNewABItem.this.setEnabled(false);
                return;
            }
            AbstractFolder folder = (AbstractFolder)theEvent.getData();
            boolean enabledCreating = folder != null && folder.getNativeFolder() instanceof IContactsFolder ? !((IContactsFolder)folder.getNativeFolder()).getAddressBook(EngineCommandManager.getAddressBookManager()).isReadOnly() : EngineCommandManager.getContactsFolderAddressBook() != null;
            AbstractNewABItem.this.setEnabled(enabledCreating);
        }
    }

    private class DIRECTORY_SELECTED_Listener
    extends AppEventListener {
        private DIRECTORY_SELECTED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            Object data = theEvent.getData();
            AbstractNewABItem.this.setMVCModel(data);
            boolean isProxyDataStore = EngineCommandManager.getInstance(ControlsUtils.getUserGuid(AbstractNewABItem.this.getActionList())).isProxyDataStore();
            if (isProxyDataStore) {
                AbstractNewABItem.this.setEnabled(false);
                return;
            }
            if (data instanceof GroupWiseAddressBook) {
                AbstractNewABItem.this.setEnabled(false);
            } else if (data instanceof AbstractAddressBook && !((AbstractAddressBook)data).isReadOnly()) {
                AbstractNewABItem.this.setEnabled(true);
            } else {
                AbstractNewABItem.this.setEnabled(false);
            }
        }
    }
}

