/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ApplicationFrameActionList;
import com.appframework.mvc.GlobalCommand;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.actions.AbstractActionBusySearch;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.busysearch.BusySearchDialog;
import com.novell.gw.jclient.application.controls.busysearch.BusySearchFrame;
import com.novell.gw.jclient.application.controls.busysearch.BusySearchFrameActionList;
import com.novell.gw.jclient.application.controls.busysearch.BusySearchUtils;
import com.novell.gw.jclient.application.controls.busysearch.GWBusySearch;
import com.novell.gw.jclient.application.controls.busysearch.RecipientDescriptionsList;
import com.novell.gw.jclient.application.frames.compose.FrameComposeAppointment;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.List;
import javax.swing.JOptionPane;

public class ActionBusySearchCompose
extends AbstractActionBusySearch {
    private List<IRecipient> recipientsList;
    private long lastStartDate;
    private long lastDuration;

    public ActionBusySearchCompose(ApplicationFrameActionList theAppActionList) {
        super(theAppActionList, ActionKey.BUSYSEARCH_COMPOSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(ActionEvent event) {
        Object view = this.getActionList().getMVCView();
        if (view instanceof FrameComposeAppointment) {
            FrameComposeAppointment frameComposeAppointment = (FrameComposeAppointment)view;
            frameComposeAppointment.getItemEdit().hideTFPopups();
            AbstractCalendarItem calendarItem = (AbstractCalendarItem)frameComposeAppointment.getNewItem();
            long startDate = calendarItem.getStartDate().getTime();
            TimeInterval appointmentTimeInterval = new TimeInterval(calendarItem.getStartDate(), calendarItem.getEndDate());
            int daysCount = 7;
            List<IRecipient> recipients = calendarItem.getRecipientsList();
            boolean updateFrame = !((Object)recipients).equals(this.recipientsList) || this.lastStartDate != startDate || this.lastDuration != (long)appointmentTimeInterval.getDuration();
            this.recipientsList = recipients;
            this.lastStartDate = startDate;
            this.lastDuration = appointmentTimeInterval.getDuration();
            RecipientDescriptionsList recipientDescriptionsList = new RecipientDescriptionsList(recipients);
            if (recipientDescriptionsList.size() <= 0) {
                BusySearchDialog inviteToMeetingDialog = new BusySearchDialog(frameComposeAppointment, frameComposeAppointment.getController());
                inviteToMeetingDialog.pack();
                inviteToMeetingDialog.setLocationRelativeTo(null);
                inviteToMeetingDialog.setVisible(true);
                if (!inviteToMeetingDialog.isOkActionProcessed()) {
                    return;
                }
                startDate = inviteToMeetingDialog.getStartDate().getTime();
                daysCount = inviteToMeetingDialog.getDaysCount();
                recipientDescriptionsList = inviteToMeetingDialog.getRecepientDescriptinsList();
                inviteToMeetingDialog.dispose();
            }
            try {
                MessageUtils.showBusyCursor(true);
                if (!BusySearchUtils.hasValidRecipient(recipientDescriptionsList.getDistributionList())) {
                    JOptionPane.showMessageDialog(null, StringResources.BYSY_SEARCH_NO_VALID_USERS);
                    return;
                }
                GWBusySearch gwBusySearch = GWCommandManager.getInstance(this.getUserGuid()).composeBusySearch(recipientDescriptionsList, new Date(startDate), daysCount, appointmentTimeInterval);
                BusySearchFrame busySearchFrame = new BusySearchFrame(gwBusySearch, GWClient.getApplication(), this.getUserGuid(), frameComposeAppointment);
                busySearchFrame.showMe();
                GlobalCommand command = new GlobalCommand(480, busySearchFrame);
                ((BusySearchFrameActionList)busySearchFrame.getController()).processCommand(command);
            }
            catch (GWCommandException e) {
                logger.error((Object)e, (Throwable)e);
            }
            finally {
                MessageUtils.showBusyCursor(false);
            }
        }
    }
}

