/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.mvc.GlobalCommand;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.panelviews.MultiPanelView;
import com.novell.gw.jclient.application.controls.panelviews.MultiPanelViewModel;
import com.novell.gw.jclient.application.controls.panelviews.MultiPanelViewModelManager;
import com.novell.gw.jclient.application.controls.panelviews.PanelView;
import com.novell.gw.jclient.application.dialogs.folderproperties.CustomizePanelsDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.utils.SortInfo;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ActionClosePanel
extends AppAction {
    private static Logger logger = Logger.getLogger(ActionClosePanel.class);

    public ActionClosePanel(ActionList theAppActionList) {
        super(theAppActionList, ActionKey.CLOSE_PANEL, StringResources.CLOSE);
    }

    protected void performAction(ActionEvent e) {
        MessageUtils.showBusyCursor(true);
        PanelView panelView = (PanelView)this.getMVCModel();
        AbstractFolder multiViewFolder = panelView.getMultiPanelViewFolder();
        MultiPanelViewModel multiPanelModel = MultiPanelViewModelManager.getInstance().getModel(multiViewFolder.getNativeFolder(), this.getUserGuid());
        multiPanelModel.remove(panelView.getColumn(), panelView.getColumnPosition());
        MultiPanelView multiPanelView = ((GWMainAppFrame)SwingUtilities.getWindowAncestor(panelView)).getMultiPanelView();
        multiPanelView.refresh();
        if (multiPanelModel.getPanelsAmount() == 0) {
            this.processEmptyModel(multiPanelView, multiViewFolder);
        }
        MessageUtils.showBusyCursor(false);
    }

    private void processEmptyModel(MultiPanelView multiPanelView, AbstractFolder folder) {
        logger.debug((Object)"no panels left > showing CustomizePanelsDialog");
        boolean result = CustomizePanelsDialog.show(SwingUtilities.getWindowAncestor(multiPanelView), this.getController(), folder.getNativeFolder(), folder.getDisplaySettings(), true);
        logger.debug((Object)("dialog result: " + result));
        MultiPanelViewModel multiPanelModel = MultiPanelViewModelManager.getInstance().getModel(folder.getNativeFolder(), this.getUserGuid());
        if (multiPanelModel.getPanelsAmount() > 0) {
            ((GWMainAppFrame)SwingUtilities.getWindowAncestor(multiPanelView)).getMultiPanelView().refresh();
        } else {
            logger.debug((Object)"reseting to Details view mode");
            folder.getDisplaySettings().setViewMode(1);
            GWClient.getApplication().processCommand(new GlobalCommand(1010, folder));
            GWClient.getApplication().processCommand(new GlobalCommand(1020, new SortInfo(folder)));
            this.getController().getActionList().performAction(ActionKey.REFRESH);
        }
    }
}

