/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.AppAction;
import com.appframework.ApplicationFrame;
import com.appframework.ApplicationFrameActionList;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.AddressBookListDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import com.novell.gw.jclient.bl.om.directory.PersonalAddressBook;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class ActionDeleteAddressBooks
extends AppAction {
    private static Logger logger = Logger.getLogger(ActionDeleteAddressBooks.class);

    public ActionDeleteAddressBooks(ApplicationFrameActionList theAppActionList) {
        super(theAppActionList, ActionKey.DELETE_ADDRESSBOOKS, StringResources.DELETE_BOOK_D);
    }

    protected void performAction(ActionEvent e) {
        try {
            ArrayList<PersonalAddressBook> dirs = new ArrayList<PersonalAddressBook>();
            for (AbstractAddressBook addressBook : EngineCommandManager.getAddressBooks()) {
                PersonalAddressBook personalAddressBook;
                if (!(addressBook instanceof PersonalAddressBook) || (personalAddressBook = (PersonalAddressBook)addressBook).getNativeAddressBook().isFrequentContacts()) continue;
                dirs.add(personalAddressBook);
            }
            AddressBookListDialog deleteAddressBookDialog = new AddressBookListDialog((ApplicationFrame)this.getActionList().getMVCView(), dirs);
            deleteAddressBookDialog.setTitle(StringResources.DELETE_ADDRESS_BOOK);
            deleteAddressBookDialog.showMe();
            if (deleteAddressBookDialog.isActionCompleteSuccessfully()) {
                Object[] selectedDirectories;
                for (Object selectedDirectory : selectedDirectories = deleteAddressBookDialog.getSelectedDirectories()) {
                    int result = JOptionPane.showConfirmDialog(this.getActionList().getOwnerComponent(), StringResources.formatString(StringResources.DELETING_THE_ADDRESS_BOOK_NAMED_Q, ((AbstractAddressBook)selectedDirectory).getName(), ((AbstractAddressBook)selectedDirectory).getName()), StringResources.ADDRESS_BOOK_K_QUESTION, 0);
                    if (result != 0) continue;
                    EngineCommandManager.deleteAddressBook((PersonalAddressBook)selectedDirectory);
                }
            }
        }
        catch (EngineException e1) {
            logger.error((Object)e1, (Throwable)e1);
        }
    }
}

