/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.GlobalCommand;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.itemedit.ComposeMode;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListView;
import com.novell.gw.jclient.application.frames.compose.FrameComposeActionList;
import com.novell.gw.jclient.application.frames.compose.FrameComposeDiscussion;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.exceptions.ItemNotCreatedException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.NntpSubFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.MailItem;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionNewDiscussion
extends AppAction<AbstractFolder> {
    private static Logger logger = Logger.getLogger(ActionNewDiscussion.class);

    public ActionNewDiscussion(ActionList theAppActionList) {
        super(theAppActionList, ActionKey.NEW_DISCUSSION, StringResources.NEW_DISCUSSION, ImageResources.NNTP_NEW_DISCUSSION);
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 2070, new ITEM_LIST_VIEW_SELECTED_Listener()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractItem item = null;
        try {
            item = GWCommandManager.getInstance(this.getUserGuid()).composeNewItem(MailItem.class, false, (AbstractFolder)this.getMVCModel());
        }
        catch (ItemNotCreatedException ex) {
            return;
        }
        catch (GWCommandException e1) {
            logger.error((Object)e1);
            logger.debug((Object)e1, (Throwable)e1);
        }
        NntpSubFolder nntpSubFolder = (NntpSubFolder)this.getMVCModel();
        MessageUtils.prepareNewNntpMessage(item, nntpSubFolder);
        FrameComposeDiscussion frame = new FrameComposeDiscussion(item, GWClient.getApplication(), ComposeMode.NEW, ControlsUtils.getUserGuid(this.getController()));
        frame.showMe();
        GlobalCommand command = new GlobalCommand(480, frame);
        ((FrameComposeActionList)frame.getController()).processCommand(command);
    }

    private class ITEM_LIST_VIEW_SELECTED_Listener
    extends AppEventListener {
        private ITEM_LIST_VIEW_SELECTED_Listener() {
        }

        public void handle(AppEvent event) {
            Object data = event.getData();
            if (data instanceof ItemListView) {
                ActionNewDiscussion.this.setMVCModel(((ItemListView)data).getAbstractFolder());
            } else {
                ActionNewDiscussion.this.setMVCModel(null);
            }
        }
    }
}

