/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrame;
import com.appframework.ApplicationFrameActionList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.addressbook.table.AddressBookTableModel;
import com.novell.gw.jclient.application.frames.addressbook.FrameAddressBook;
import com.novell.gw.jclient.application.printing.PrintManagerDialog;
import com.novell.gw.jclient.application.printing.printingaddressbook.PrintAddressBookDialog;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionPrintAddressBook
extends AppAction {
    public ActionPrintAddressBook(ApplicationFrameActionList theAppActionList) {
        super((ActionList)theAppActionList, ActionKey.PRINT_ADDRESSBOOK, StringResources.PRINT_ADDRESS_BOOK, ImageResources.ACT_PRINT);
        this.setAccelerator(KeyStroke.getKeyStroke(80, OS.getMetaKey()));
    }

    @Override
    protected void performAction(ActionEvent e) {
        List<IAddressable> selectedContacts = ((FrameAddressBook)this.getActionList().getMVCView()).getTableAddressBook().getSelectedContacts();
        if (selectedContacts != null && selectedContacts.size() == 1) {
            PrintAddressBookDialog dlg = new PrintAddressBookDialog((FrameAddressBook)this.getActionList().getMVCView(), true);
            dlg.showMe();
            if (dlg.isActionCompleteSuccessfully()) {
                if (!dlg.isSelectItem()) {
                    selectedContacts = this.initContacts();
                }
                this.showPrintDialog(selectedContacts);
            }
        } else if (selectedContacts != null && selectedContacts.size() > 0) {
            this.showPrintDialog(selectedContacts);
        } else {
            this.showPrintDialog(this.initContacts());
        }
    }

    private void showPrintDialog(List<IAddressable> selectedContacts) {
        PrintManagerDialog printManagerDialog = new PrintManagerDialog((ApplicationFrame)this.getActionList().getOwnerComponent(), selectedContacts);
        UIUtils.centerWindow((Window)printManagerDialog, (ApplicationFrame)this.getActionList().getMVCView());
        printManagerDialog.setVisible(true);
    }

    private List<IAddressable> initContacts() {
        IItemList itemList = ((AddressBookTableModel)((FrameAddressBook)this.getActionList().getMVCView()).getTableAddressBook().getModel()).getItemList();
        ArrayList<IAddressable> selectedContacts = new ArrayList<IAddressable>();
        int nCount = itemList.getSize();
        for (int i = 0; i < nCount; ++i) {
            IItem item = itemList.getItemAt(i);
            if (!(item instanceof IContact)) continue;
            selectedContacts.add((IAddressable)((Object)item));
        }
        return selectedContacts;
    }

    @Override
    protected void registerListeners() {
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 360, new DIRECTORY_SELECTED_Listener()));
    }

    private class DIRECTORY_SELECTED_Listener
    extends AppEventListener {
        private DIRECTORY_SELECTED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            ActionPrintAddressBook.this.setMVCModel(theEvent.getData());
        }
    }
}

