/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.ApplicationFrame;
import com.appframework.ApplicationFrameActionList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.novell.gw.jclient.api.enums.DataStoreAccessRequestType;
import com.novell.gw.jclient.api.enums.ItemType;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.item.AbstractMultipleItemsAction;
import com.novell.gw.jclient.application.controls.folderstree.MainGWFoldersTree;
import com.novell.gw.jclient.application.dialogs.rules.RulesDialog;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ActionRules
extends AbstractMultipleItemsAction {
    private static Logger logger = Logger.getLogger(ActionRules.class);
    private AbstractFolder folder;

    public ActionRules(ApplicationFrameActionList theAppActionList) {
        super((ActionList)theAppActionList, ActionKey.RULES, StringResources.ACTION_RULES, ImageResources.ACT_RULES);
        this.setToolTipText(StringResources.DESCRIPTION_RULES);
    }

    protected boolean checkEnableOnSelect() {
        GWCommandManager gwCM = GWCommandManager.getInstance(this.getUserGuid());
        boolean isArchive = gwCM.isArchive();
        boolean isBackUpDataStore = gwCM.isBackupDB();
        boolean accessAllowed = gwCM.getCurrentDataStore().checkAccess(DataStoreAccessRequestType.EDIT_RULES, ItemType.ANY, 0);
        boolean enable = !isArchive && !isBackUpDataStore && accessAllowed;
        return enable;
    }

    protected void performAction(ActionEvent e) {
        logger.debug((Object)("folder: " + this.folder + "; has items: " + this.hasItems()));
        RulesDialog rulesDialog = new RulesDialog((ApplicationFrame)this.getActionList().getMVCView(), this.folder, this.getSelectedItems());
        rulesDialog.pack();
        rulesDialog.setLocationRelativeTo(null);
        rulesDialog.setVisible(true);
        rulesDialog.dispose();
    }

    private IItem[] getSelectedItems() {
        ArrayList<IItem> result = new ArrayList<IItem>();
        if (this.hasItems()) {
            for (AbstractItem item : this.getItems()) {
                result.add(item.getNativeObject());
            }
        }
        return result.toArray(new IItem[result.size()]);
    }

    protected void handle_MULTIPLE_ITEMS_SELECTED(AppEvent theEvent) {
        super.handle_MULTIPLE_ITEMS_SELECTED(theEvent);
        this.setMVCModel(theEvent.getData());
    }

    protected void handle_OPEN_FOLDER(AppEvent theEvent) {
        super.handle_OPEN_FOLDER(theEvent);
        this.folder = (AbstractFolder)theEvent.getData();
    }

    protected void registerListeners() {
        super.registerListeners();
        Level level = this.getController().getFrameLevel();
        AppEventListener listener = new EnableListener();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 800, listener));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 750, listener));
        listener = new ILTREE_FOCUS_GAINED_Listener();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 1980, listener));
        listener = new ITEM_LIST_VIEW_SELECTED_Listener();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 2070, listener));
    }

    private class ITEM_LIST_VIEW_SELECTED_Listener
    extends AppEventListener {
        private ITEM_LIST_VIEW_SELECTED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            ActionRules.this.folder = null;
        }
    }

    private class ILTREE_FOCUS_GAINED_Listener
    extends AppEventListener {
        private ILTREE_FOCUS_GAINED_Listener() {
        }

        public void handle(AppEvent event) {
            ActionRules.this.folder = ((MainGWFoldersTree)event.getData()).getSelectedFolder();
        }
    }

    private class EnableListener
    extends AppEventListener {
        private EnableListener() {
        }

        public void handle(AppEvent theEvent) {
            ActionRules.this.setEnabled(ActionRules.this.checkEnableOnSelect());
        }
    }
}

