/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrameActionList;
import com.appframework.components.ButtonList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.GlobalCommand;
import com.appframework.utils.OS;
import com.novell.gw.jclient.api.enums.EngineMode;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.StorageMode;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;

public class ActionSwitchCaching
extends AppAction {
    private ButtonList buttons = new ButtonList();

    public ActionSwitchCaching(ApplicationFrameActionList theAppActionList) {
        super((ActionList)theAppActionList, ActionKey.SWITCH_CACHING, StringResources.CACHING, ImageResources.ACT_SWITCH_CACHING);
        this.setType(AppAction.ActionType.CHECKABLE);
    }

    public JMenuItem getMenuItem() {
        JMenuItem menuItem = OS.createMenuItem(this);
        this.buttons.add(menuItem);
        this.setSelected();
        this.setEnabled(EngineCommandManager.canSwitchCaching());
        return menuItem;
    }

    private void setSelected() {
        this.setSelected(EngineCommandManager.getCurrentMode() == EngineMode.CACHING);
        this.buttons.setSelected(this.isSelected());
    }

    protected void performAction(ActionEvent e) {
        if (!this.isSelected()) {
            GWCommandManager.getInstance(this.getUserGuid()).switchToCaching();
            if (this.getController() != null) {
                this.getController().processCommand(new GlobalCommand(730));
            }
        }
    }

    protected void registerListeners() {
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 750, new PROXY_DATA_STORE_INSTALLED_Listener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 800, new STORE_MODE_CHANGED_Listener()));
        ACTION_SWITCH_CACHING_PERFORMED_ACTION_SWITCH_ONLINE_PERFORMED_Listener listener = new ACTION_SWITCH_CACHING_PERFORMED_ACTION_SWITCH_ONLINE_PERFORMED_Listener();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 730, listener));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 740, listener));
    }

    private class ACTION_SWITCH_CACHING_PERFORMED_ACTION_SWITCH_ONLINE_PERFORMED_Listener
    extends AppEventListener {
        private ACTION_SWITCH_CACHING_PERFORMED_ACTION_SWITCH_ONLINE_PERFORMED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            ActionSwitchCaching.this.setSelected();
            ActionSwitchCaching.this.setEnabled(EngineCommandManager.canSwitchCaching());
        }
    }

    private class STORE_MODE_CHANGED_Listener
    extends AppEventListener {
        private STORE_MODE_CHANGED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            StorageMode storeMode = (StorageMode)theEvent.getData();
            ActionSwitchCaching.this.setEnabled(storeMode.isNormal());
        }
    }

    private class PROXY_DATA_STORE_INSTALLED_Listener
    extends AppEventListener {
        private PROXY_DATA_STORE_INSTALLED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            ActionSwitchCaching.this.setEnabled(false);
        }
    }
}

