/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.AppAction;
import com.appframework.ApplicationFrame;
import com.appframework.ApplicationFrameActionList;
import com.appframework.components.ButtonList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.novell.gw.jclient.api.enums.DataStoreAccessRequestType;
import com.novell.gw.jclient.api.enums.ItemType;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.dialogs.rules.VacationRuleDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;

public class ActionVacationRule
extends AppAction {
    private ButtonList buttons = new ButtonList();

    public ActionVacationRule(ApplicationFrameActionList theAppActionList) {
        super(theAppActionList, ActionKey.VACATION_RULE, StringResources.ACTION_VACATION_RULE);
        this.setToolTipText(StringResources.DESCRIPTION_VACATION_RULE);
        this.setType(AppAction.ActionType.CHECKABLE);
    }

    private boolean isAvailable() {
        GWCommandManager commandManager = GWCommandManager.getInstance(this.getUserGuid());
        boolean isArchive = commandManager.isArchive();
        boolean isBackUpDataStore = commandManager.isBackupDB();
        boolean accessAllowed = commandManager.getCurrentDataStore().checkAccess(DataStoreAccessRequestType.EDIT_RULES, ItemType.ANY, 0);
        return !isArchive && !isBackUpDataStore && accessAllowed;
    }

    private boolean isVacationRuleActive() {
        GWCommandManager commandManager = EngineCommandManager.getInstance(this.getUserGuid());
        IDataStore dataStore = commandManager.getCurrentDataStore();
        return dataStore.isVacationRuleActive();
    }

    protected void performAction(ActionEvent e) {
        VacationRuleDialog vacationRuleDialog = new VacationRuleDialog((ApplicationFrame)this.getActionList().getMVCView());
        vacationRuleDialog.setVisible(true);
        this.setSelected(this.isVacationRuleActive());
    }

    protected void registerListeners() {
        super.registerListeners();
        Level level = this.getController().getFrameLevel();
        EnableListener listener = new EnableListener();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 800, listener));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 750, listener));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 335, new SelectionListener()));
    }

    public JMenuItem getMenuItem() {
        JMenuItem menuItem = super.getMenuItem();
        this.buttons.add(menuItem);
        this.setSelected(this.isVacationRuleActive());
        return menuItem;
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (this.buttons != null && this.buttons.size() > 0) {
            this.buttons.setSelected(selected);
        }
    }

    private class SelectionListener
    extends AppEventListener {
        private SelectionListener() {
        }

        public void handle(AppEvent event) {
            ActionVacationRule.this.setSelected(ActionVacationRule.this.isVacationRuleActive());
        }
    }

    private class EnableListener
    extends AppEventListener {
        private EnableListener() {
        }

        public void handle(AppEvent theEvent) {
            ActionVacationRule.this.setEnabled(ActionVacationRule.this.isAvailable());
        }
    }
}

