/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.contact;

import com.appframework.ActionList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.LevelManager;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.utils.OS;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.contact.AbstractContactAction;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import java.awt.event.ActionEvent;
import java.util.WeakHashMap;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class ActionDeleteContact
extends AbstractContactAction {
    private static Logger logger = Logger.getLogger(ActionDeleteContact.class);
    private WeakHashMap menuItems = new WeakHashMap();

    public ActionDeleteContact(ActionList theAppActionList) {
        super(theAppActionList, ActionKey.DELETE_CONTACT, StringResources.DELETE, ImageResources.ACT_ITEM_REMOVE);
        this.setEnabled(false);
        this.setAccelerator(KeyStroke.getKeyStroke(OptionManager.getInstance().getGeneralOptions().getItemDeleteKey(), 0));
        this.showWithText();
        this.addListenerDescriptor(new AppEventListenerDescriptor(LevelManager.getInstance().getGlobalLevel(), 1410, new ITEM_DELETE_KEY_CHANGED_listener()));
    }

    protected void performAction(ActionEvent e) {
        try {
            GWEngineUtils.deleteContacts(this.getContacts(), this.getActionList().getOwnerComponent());
        }
        catch (EngineException e1) {
            logger.error((Object)e1);
        }
    }

    protected boolean checkEnableOnSelect() {
        if (this.hasContacts()) {
            for (IContact contact : this.getContacts()) {
                if (!contact.isReadOnly()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public JMenuItem getMenuItem() {
        JMenuItem item = OS.createMenuItem(this);
        item.setAccelerator(KeyStroke.getKeyStroke(OptionManager.getInstance().getGeneralOptions().getItemDeleteKey(), 0));
        this.menuItems.put(item, item);
        return item;
    }

    private class ITEM_DELETE_KEY_CHANGED_listener
    extends AppEventListener {
        private ITEM_DELETE_KEY_CHANGED_listener() {
        }

        public void handle(AppEvent theEvent) {
            ActionDeleteContact.this.setAccelerator(KeyStroke.getKeyStroke(OptionManager.getInstance().getGeneralOptions().getItemDeleteKey(), 0));
            for (JMenuItem menuItem : ActionDeleteContact.this.menuItems.values()) {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(OptionManager.getInstance().getGeneralOptions().getItemDeleteKey(), 0));
            }
        }
    }
}

