/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.contact;

import com.appframework.ActionList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.Command;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.ab.IGroupContact;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.contact.AbstractContactAction;
import com.novell.gw.jclient.application.controls.addressbook.AbstractAddressSelectorDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ActionExpandGroup
extends AbstractContactAction {
    private static Logger logger = Logger.getLogger(ActionExpandGroup.class);

    public ActionExpandGroup(ActionList theActionList) {
        super(theActionList, ActionKey.EXPAND_GROUP, StringResources.EXPAND_GROUP);
    }

    protected void registerListeners() {
        super.registerListeners();
        Level level = this.getController().getFrameLevel();
        DIRECTORY_SELECTED_Listener listener = new DIRECTORY_SELECTED_Listener();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 360, listener));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 390, listener));
    }

    protected boolean checkEnableOnSelect() {
        return this.hasContacts() && this.getContacts().size() == 1 && this.getContact() instanceof IGroupContact;
    }

    protected void performAction(ActionEvent e) {
        try {
            ArrayList<IRecipient> recipients = new ArrayList<IRecipient>();
            IItemList members = ((IGroupContact)this.getContact()).getMembers();
            for (int i = 0; i < members.getSize(); ++i) {
                IContact contact = (IContact)members.getItemAt(i);
                recipients.add(APIAbWrapperManager.createRecipient(contact, contact.getDistributionType()));
            }
            Command command = new Command(380, recipients);
            this.getController().processCommand(command);
        }
        catch (EngineException ex) {
            logger.error((Object)ex);
            logger.debug((Object)ex, (Throwable)ex);
        }
    }

    private class DIRECTORY_SELECTED_Listener
    extends AppEventListener {
        private DIRECTORY_SELECTED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            if (!(ActionExpandGroup.this.getActionList().getMVCView() instanceof AbstractAddressSelectorDialog) || ActionExpandGroup.this.getActionList().getMVCView() == AbstractAddressSelectorDialog.getLastInstance()) {
                ActionExpandGroup.this.setMVCModel((Object)null);
                ActionExpandGroup.this.setEnabled(false);
            }
        }
    }
}

