/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.filter;

import com.appframework.ActionList;
import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.interfaces.ICategory;
import com.novell.gw.jclient.api.interfaces.ICategoryList;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.application.controls.FilterUtils;
import com.novell.gw.jclient.application.controls.orientable.MenuItemFactory;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.filter.Filter;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionFilterByCategories
extends AbstractAction {
    private JMenuItem menuItem;
    private Filter filter;
    private ActionList actionList;
    private Set<ICategory> categories;

    public ActionFilterByCategories(ActionList actionList, Filter filter, ICategory category) {
        if (actionList == null) {
            throw new IllegalArgumentException("actionList is null");
        }
        if (category == null) {
            throw new IllegalArgumentException("category is null");
        }
        this.actionList = actionList;
        this.filter = filter;
        this.menuItem = MenuItemFactory.createCkeckBoxMenuItem(this);
        this.menuItem.setText(category.getName());
        IDataStore ds = EngineCommandManager.getInstance(EngineCommandManager.getUserGuid()).getCurrentDataStore();
        if (this.filter != null && this.filter.getItemListFilter().getCategories(ds.getNativeDataStore()) != null) {
            ICategoryList ic = APIWrapperManager.getCategoryList(this.filter.getItemListFilter().getCategories(ds.getNativeDataStore()));
            this.menuItem.setSelected(ic.findCategoryIndex(category) > -1);
        } else {
            this.menuItem.setSelected(false);
        }
        this.categories = new HashSet<ICategory>();
        this.categories.add(category);
    }

    public ActionFilterByCategories(ActionList actionList, Filter filter, Set<ICategory> categories, String actionName) {
        if (actionList == null) {
            throw new IllegalArgumentException("actionList is null");
        }
        if (categories == null) {
            throw new IllegalArgumentException("categories is null");
        }
        if (actionName == null) {
            throw new IllegalArgumentException("actionName is null");
        }
        this.actionList = actionList;
        this.filter = filter;
        this.menuItem = MenuItemFactory.createMenuItem(this);
        this.menuItem.setText(actionName);
        this.categories = categories;
    }

    public JMenuItem getMenuItem() {
        return this.menuItem;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FilterUtils.filterByCategory(this.filter, this.categories, this.actionList);
    }
}

