/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.filter;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.filter.FiltersFactory;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.Command;
import com.appframework.utils.UIUtils;
import com.novell.gw.ab.AddressBookItemListFilter;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.addressbook.ABUtils;
import com.novell.gw.jclient.application.controls.filter.AdvancedFilter;
import com.novell.gw.jclient.application.controls.filter.ContactFilter;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButtonMenuItem;
import com.novell.gw.jclient.bl.om.filter.Filter;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;

public abstract class ActionSwitchContactFilter
extends AppAction {
    protected JMenuItem menuItem;

    protected ActionSwitchContactFilter(ActionList actionList, ActionKey actionKey, String name) {
        super(actionList, actionKey, name);
        this.setEnabled(true);
    }

    protected void performAction(ActionEvent e) {
        AddressBookItemListFilter abilf;
        Filter filter = FiltersFactory.getInstance().getFilter(this.getController());
        int box = ((AddressBookItemListFilter)this.getContactFilter().getItemListFilter()).getContactType();
        boolean isSystem = ABUtils.isSystemABAbstractFolder(this.actionList);
        if (filter == null || filter.isEmpty()) {
            abilf = new AddressBookItemListFilter(isSystem);
            abilf.setContactType(box);
            filter = new ContactFilter(abilf, isSystem);
        } else if (!(filter.getItemListFilter() instanceof AddressBookItemListFilter)) {
            abilf = new AddressBookItemListFilter(isSystem);
            abilf.setContactType(box);
            filter = new ContactFilter(abilf, isSystem);
        } else {
            filter = new AdvancedFilter(filter.getItemListFilter(), true);
            ((AdvancedFilter)filter).setContactType(true);
            ((AddressBookItemListFilter)filter.getItemListFilter()).setContactType(box);
        }
        Command command = new Command(400, filter);
        this.getController().processCommand(command);
    }

    public JMenuItem getMenuItem() {
        if (this.menuItem == null) {
            this.menuItem = new OrientableRadioButtonMenuItem(this);
            this.menuItem.setComponentOrientation(UIUtils.getComponentOrientation());
        }
        return this.menuItem;
    }

    protected void registerListeners() {
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 400, new FILTER_CHANGED_Listener()));
    }

    protected abstract ContactFilter getContactFilter();

    protected ContactFilter getContactFilter(int typeContact) {
        boolean isSystemAB = ABUtils.isSystemABAbstractFolder(this.actionList);
        AddressBookItemListFilter abFilter = new AddressBookItemListFilter(isSystemAB);
        abFilter.setContactType(typeContact);
        return new ContactFilter(abFilter, isSystemAB);
    }

    private class FILTER_CHANGED_Listener
    extends AppEventListener {
        private FILTER_CHANGED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            ActionSwitchContactFilter action = ActionSwitchContactFilter.this;
            if (action.menuItem == null) {
                return;
            }
            if (theEvent.getData() instanceof AdvancedFilter && ((AdvancedFilter)theEvent.getData()).isContactType() && ((AdvancedFilter)theEvent.getData()).canDiplayType() || theEvent.getData() instanceof ContactFilter) {
                if (((AddressBookItemListFilter)((Filter)theEvent.getData()).getItemListFilter()).getContactType() == ((AddressBookItemListFilter)ActionSwitchContactFilter.this.getContactFilter().getItemListFilter()).getContactType()) {
                    action.menuItem.setSelected(true);
                } else {
                    action.menuItem.setSelected(false);
                }
            } else {
                action.menuItem.setSelected(false);
            }
        }
    }
}

