/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.folder;

import com.appframework.AppAction;
import com.appframework.ApplicationFrameActionList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.GWMainAppFrameActionList;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class ActionNewCalendar
extends AppAction {
    private static Logger logger = Logger.getLogger(ActionNewCalendar.class);

    public ActionNewCalendar(ApplicationFrameActionList theAppActionList) {
        super(theAppActionList, ActionKey.NEW_CALENDAR, StringResources.NEW_CALENDAR);
    }

    protected void performAction(ActionEvent e) {
        MessageUtils.showBusyCursor(true);
        String userGuid = this.getUserGuid();
        GWCommandManager manager = EngineCommandManager.getInstance(userGuid);
        IFolder[] calendarFolders = manager.getCurrentDataStore().getCalendarFolders();
        AbstractFolder mainCalendarFolder = manager.getGWFolder(calendarFolders[0]);
        ActionNewCalendar.doPerformAction(mainCalendarFolder, this.getController());
        MessageUtils.showBusyCursor(false);
    }

    private static void doPerformAction(AbstractFolder parentFolder, MVCController controller) {
        String newCalendarFolderName = GWEngineUtils.createNameForNewFolder(parentFolder.getNativeFolder(), true);
        if (controller instanceof GWMainAppFrameActionList) {
            ((GWMainAppFrame)((GWMainAppFrameActionList)controller).getMVCView()).getFoldersTree().createNewCalendarFolder(parentFolder, newCalendarFolderName);
        } else {
            logger.debug((Object)("controller: " + controller));
            GWCommandManager.getInstance(ControlsUtils.getUserGuid(controller)).createCalendarFolder(newCalendarFolderName, parentFolder.getNativeFolder());
        }
    }

    protected void registerListeners() {
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 10, new FOLDER_SELECTED_Listener()));
    }

    protected class FOLDER_SELECTED_Listener
    extends AppEventListener {
        protected FOLDER_SELECTED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            AbstractFolder folder = (AbstractFolder)theEvent.getData();
            ActionNewCalendar.this.setMVCModel(folder);
        }
    }
}

