/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.folder;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.novell.gw.account.Account;
import com.novell.gw.account.AccountFolderList;
import com.novell.gw.account.NntpAccount;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.dialogs.SubscribeNewsgroupDialog;
import com.novell.gw.jclient.application.frames.options.AccountUtils;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.NntpFolder;
import java.awt.event.ActionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionSubscribeNewsgroups
extends AppAction<NntpFolder> {
    public ActionSubscribeNewsgroups(ActionList theAppActionList) {
        super(theAppActionList, ActionKey.SUBSCRIBE_TO_NEWSGROUPS, StringResources.SUBSCRIBE_TO_NEWSFROUPS_D, ImageResources.NNTP_SUBSCRIBE);
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 10, new FolderSelectionListener()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        NntpFolder folder = (NntpFolder)this.getMVCModel();
        if (folder == null) {
            throw new NullPointerException("Nntp folder must be set for subscribe action");
        }
        Account account = AccountUtils.getAccountForFolder(folder.getNativeFolder());
        if (account == null) {
            throw new NullPointerException("no account for folder. Maybe wrong MVC model set");
        }
        AccountFolderList afl = ((NntpAccount)account).getAllNNTPFolders();
        if (afl.getNumFolders() != 0) {
            SubscribeNewsgroupDialog.showDialog(ControlsUtils.getFrameForController(this.getController()), account);
        }
    }

    private class FolderSelectionListener
    extends AppEventListener {
        private FolderSelectionListener() {
        }

        public void handle(AppEvent theEvent) {
            AbstractFolder folder = (AbstractFolder)theEvent.getData();
            if (folder instanceof NntpFolder) {
                ActionSubscribeNewsgroups.this.setMVCModel((NntpFolder)folder);
            }
        }
    }
}

