/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.item;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.componentrelated.ActionCalendar;
import com.novell.gw.jclient.application.actions.componentrelated.ActionMessageTable;
import com.novell.gw.jclient.application.actions.componentrelated.ActionQuickViewer;
import com.novell.gw.jclient.application.interfaces.ISelectedItemsInfo;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import javax.swing.Icon;

public abstract class AbstractGWItemAction
extends AppAction
implements ActionMessageTable,
ActionQuickViewer,
ActionCalendar {
    protected AbstractGWItemAction(ActionList actionList, ActionKey actionKey, String name) {
        super(actionList, actionKey, name);
        this.setEnabled(false);
    }

    protected AbstractGWItemAction(ActionList actionList, ActionKey actionKey, String name, Icon icon) {
        super(actionList, actionKey, name, icon);
        this.setEnabled(false);
    }

    protected boolean hasItemList() {
        ISelectedItemsInfo itemsInfo = this.getItemsInfo();
        return itemsInfo != null && itemsInfo.hasItemList();
    }

    protected boolean hasFolders() {
        ISelectedItemsInfo itemsInfo = this.getItemsInfo();
        return itemsInfo != null && itemsInfo.hasFolders();
    }

    protected boolean hasItems() {
        ISelectedItemsInfo itemsInfo = this.getItemsInfo();
        return itemsInfo != null && itemsInfo.hasItems();
    }

    protected AbstractItem getItem() {
        return this.getItemsInfo().getItem();
    }

    protected IItemList getItemList() {
        return this.getItemsInfo().getItemList();
    }

    protected AbstractFolder getFolder() {
        return this.getItemsInfo().getFolder();
    }

    protected ISelectedItemsInfo getItemsInfo() {
        Object model = this.getMVCModel();
        if (model != null) {
            return (ISelectedItemsInfo)model;
        }
        return null;
    }

    protected void registerListeners() {
        Level level = this.getController().getFrameLevel();
        AppEventListener listener = new GWITEM_SELECTED_Listener();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 20, listener));
        listener = new NO_ITEMS_SELECTED_Listener();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 470, listener));
        listener = new OPEN_FOLDER_Listener();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 1090, listener));
        listener = new FOLDER_SELECTED_Listener();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 10, listener));
        listener = new MULTIPLE_ITEMS_SELECTED_Listener();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 430, listener));
        listener = new ATTACHMENT_SELECTED_Listener();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 50, listener));
        listener = new ADDRESS_BOOK_ITEMS_SELECTED_Listener();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 240, listener));
    }

    protected abstract boolean checkEnableOnSelect();

    protected void handle_GWITEM_SELECTED(AppEvent theEvent) {
        this.setMVCModel(theEvent.getData());
    }

    protected void handle_NO_ITEMS_SELECTED(AppEvent theEvent) {
        this.setMVCModel((Object)null);
    }

    protected void handle_OPEN_FOLDER(AppEvent theEvent) {
        this.setMVCModel((Object)null);
    }

    protected void handle_FOLDER_SELECTED(AppEvent theEvent) {
    }

    protected void handle_MULTIPLE_ITEMS_SELECTED(AppEvent theEvent) {
        this.setMVCModel((Object)null);
    }

    public void setMVCModel(Object theModel) {
        super.setMVCModel(theModel);
        this.setEnabled(this.checkEnableOnSelect());
    }

    protected AbstractItem getNextItem() {
        AbstractItem item = null;
        if (this.hasItemList() && this.hasItems()) {
            item = GWCommandManager.getInstance(this.getUserGuid()).getNextItem(this.getItemList(), this.getItem());
        }
        return item;
    }

    protected AbstractItem getPrevItem() {
        if (this.hasItems() && this.hasItemList()) {
            AbstractItem item = GWCommandManager.getInstance(this.getUserGuid()).getPrevItem(this.getItemList(), this.getItem());
            return item == null ? null : item;
        }
        return null;
    }

    protected void handle_ATTACHMENT_SELECTED(AppEvent theEvent) {
    }

    private void handle_ADDRESS_BOOK_ITEMS_SELECTED(AppEvent theEvent) {
        this.setMVCModel((Object)null);
    }

    private class ADDRESS_BOOK_ITEMS_SELECTED_Listener
    extends AppEventListener {
        private ADDRESS_BOOK_ITEMS_SELECTED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            AbstractGWItemAction.this.handle_ADDRESS_BOOK_ITEMS_SELECTED(theEvent);
        }
    }

    private class ATTACHMENT_SELECTED_Listener
    extends AppEventListener {
        private ATTACHMENT_SELECTED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            AbstractGWItemAction.this.handle_ATTACHMENT_SELECTED(theEvent);
        }
    }

    private class MULTIPLE_ITEMS_SELECTED_Listener
    extends AppEventListener {
        private MULTIPLE_ITEMS_SELECTED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            AbstractGWItemAction.this.handle_MULTIPLE_ITEMS_SELECTED(theEvent);
        }
    }

    private class FOLDER_SELECTED_Listener
    extends AppEventListener {
        private FOLDER_SELECTED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            AbstractGWItemAction.this.handle_FOLDER_SELECTED(theEvent);
        }
    }

    private class OPEN_FOLDER_Listener
    extends AppEventListener {
        private OPEN_FOLDER_Listener() {
        }

        public void handle(AppEvent theEvent) {
            AbstractGWItemAction.this.handle_OPEN_FOLDER(theEvent);
            AbstractGWItemAction.this.setEnabled(AbstractGWItemAction.this.checkEnableOnSelect());
        }
    }

    private class NO_ITEMS_SELECTED_Listener
    extends AppEventListener {
        private NO_ITEMS_SELECTED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            AbstractGWItemAction.this.handle_NO_ITEMS_SELECTED(theEvent);
        }
    }

    private class GWITEM_SELECTED_Listener
    extends AppEventListener {
        private GWITEM_SELECTED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            AbstractGWItemAction.this.handle_GWITEM_SELECTED(theEvent);
        }
    }
}

