/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.item;

import com.appframework.ActionList;
import com.appframework.Application;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.item.AbstractMultipleItemsAction;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public abstract class AbstractSentItemAction
extends AbstractMultipleItemsAction {
    protected AbstractSentItemAction(ActionList actionList, ActionKey actionKey, String name, Icon icon, String description) {
        super(actionList, actionKey, name);
        this.setIcon(icon);
        this.setToolTipText(description);
    }

    protected void performAction(ActionEvent e) {
        if (this.isSingleItemModel()) {
            AbstractItem item = this.getItem();
            if (item.isSentItem()) {
                this.processItem();
            }
        } else if (this.isMultipleItemsModel()) {
            this.processItems();
        } else {
            JOptionPane.showMessageDialog(this.getActionList().getOwnerComponent(), StringResources.NO_ITEM_IS_SELECTED, StringResources.GROUPWISE_CLIENT, 2);
        }
    }

    protected abstract void processItems();

    protected abstract void processItem();

    protected void deleteItem(int theDeleteRetractInfo) {
        Application.disableFrames(this.getItems());
        GWEngineUtils.deleteSentItem(this.getItemList(), this.getItem(), theDeleteRetractInfo);
    }

    protected void deleteItems(int theDeleteRetractInfo) {
        Application.disableFrames(this.getItems());
        GWEngineUtils.deleteSentItems(this.getItemList(), theDeleteRetractInfo);
    }

    protected boolean checkEnableOnSelect() {
        if (this.isSingleItemModel()) {
            AbstractItem item = this.getItem();
            return item.isSentItem() && item.canDelete();
        }
        if (this.isMultipleItemsModel()) {
            return GWEngineUtils.isItemsSent(this.getItems()) && this.getItemList().canDeleteSelectedItems();
        }
        return false;
    }
}

