/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.item;

import com.appframework.Application;
import com.appframework.ApplicationFrameActionList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.LevelManager;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.Command;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.item.AbstractMultipleItemsAction;
import com.novell.gw.jclient.application.controls.folderstree.MainGWFoldersTree;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.event.ActionEvent;
import java.util.WeakHashMap;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class ActionDeleteAndEmptyItem
extends AbstractMultipleItemsAction {
    private WeakHashMap menuItems = new WeakHashMap();

    public ActionDeleteAndEmptyItem(ApplicationFrameActionList theAppActionList) {
        super(theAppActionList, ActionKey.DELETE_AND_EMPTY_ITEM, StringResources.DELETE_AND_EMPTY);
        this.addListenerDescriptor(new AppEventListenerDescriptor(LevelManager.getInstance().getGlobalLevel(), 1410, new ITEM_DELETE_KEY_CHANGED_listener()));
        this.setAccelerator(KeyStroke.getKeyStroke(OptionManager.getInstance().getGeneralOptions().getItemDeleteKey(), 64));
    }

    protected void performAction(ActionEvent e) {
        boolean isDeletedFolder = false;
        if (this.isSingleFolderModel()) {
            isDeletedFolder = GWEngineUtils.deleteAndEmptyFolder(this.getItemList(), this.getFolder());
        } else if (this.isMultipleFoldersModel()) {
            isDeletedFolder = GWEngineUtils.deleteAndEmptyItems(this.getItemList());
        } else if (this.isSingleItemModel()) {
            MessageUtils.deleteAndEmpty(this.getItemList(), this.getItem());
        } else if (this.isMultipleItemsModel()) {
            Application.disableFrames(this.getItems());
            GWEngineUtils.deleteAndEmptyItems(this.getItemList());
        } else {
            JOptionPane.showMessageDialog(this.getActionList().getOwnerComponent(), StringResources.NO_ITEM_IS_SELECTED, StringResources.GROUPWISE_CLIENT, 2);
        }
        if (isDeletedFolder) {
            MainGWFoldersTree tree = ((GWMainAppFrame)this.getController().getMVCView()).getFoldersTree();
            Command c = new Command(2060);
            this.getController().processCommand(c);
            c = new Command(10, tree.getSelectedFolder());
            this.getController().processCommand(c);
        }
    }

    protected boolean checkEnableOnSelect() {
        if (this.isSingleFolderModel() || this.isMultipleFoldersModel()) {
            return this.getItemList().canDeleteAndEmptySelectedItems();
        }
        if (this.isSingleItemModel()) {
            return this.getItem().canDeleteAndEmpty();
        }
        if (this.isMultipleItemsModel()) {
            return this.getItemList().canDeleteAndEmptySelectedItems();
        }
        return false;
    }

    public JMenuItem getMenuItem() {
        JMenuItem item = OS.createMenuItem(this);
        this.menuItems.put(item, item);
        return item;
    }

    private class ITEM_DELETE_KEY_CHANGED_listener
    extends AppEventListener {
        private ITEM_DELETE_KEY_CHANGED_listener() {
        }

        public void handle(AppEvent theEvent) {
            ActionDeleteAndEmptyItem.this.setAccelerator(KeyStroke.getKeyStroke(OptionManager.getInstance().getGeneralOptions().getItemDeleteKey(), 64));
            for (Object o : ActionDeleteAndEmptyItem.this.menuItems.values()) {
                JMenuItem menuItem = (JMenuItem)o;
                menuItem.setAccelerator(KeyStroke.getKeyStroke(OptionManager.getInstance().getGeneralOptions().getItemDeleteKey(), 64));
            }
        }
    }
}

