/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.item;

import com.appframework.ActionList;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.item.AbstractGWItemAction;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.event.ActionEvent;
import javax.swing.Icon;

public abstract class ActionMoveCheckListItem
extends AbstractGWItemAction {
    protected ActionMoveCheckListItem(ActionList actionList, ActionKey actionKey, String name, Icon icon, String description, String toolTipText) {
        super(actionList, actionKey, name, icon);
        this.setToolTipText(toolTipText);
        this.setDescription(description);
    }

    protected abstract Move getMove();

    protected void performAction(ActionEvent e) {
        ActionMoveCheckListItem.moveCheckListItem(this.getMove(), this.getItemList(), this.getItem().getNativeItem());
    }

    protected boolean checkEnableOnSelect() {
        return this.hasItemList() && this.hasItems() && ActionMoveCheckListItem.canMoveCheckListItem(this.getMove(), this.getItemList(), this.getItem());
    }

    private static void moveCheckListItem(Move move, IItemList itemList, IItem item) {
        int index = itemList.indexOf(item);
        switch (move) {
            case BOTTOM: {
                itemList.checklistMoveToBottom(index);
                break;
            }
            case UP: {
                itemList.checklistMoveUp(index);
                break;
            }
            case DOWN: {
                itemList.checklistMoveDown(index);
                break;
            }
            case TOP: {
                itemList.checklistMoveToTop(index);
            }
        }
    }

    public static boolean canMoveCheckListItem(Move move, IItemList itemList, AbstractItem theCheckListItem) {
        int index = itemList.indexOf((IItem)theCheckListItem.getNativeItem());
        switch (move) {
            case BOTTOM: {
                return itemList.canChecklistMoveToBottom(index);
            }
            case UP: {
                return itemList.canChecklistMoveUp(index);
            }
            case DOWN: {
                return itemList.canChecklistMoveDown(index);
            }
            case TOP: {
                return itemList.canChecklistMoveToTop(index);
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Move {
        BOTTOM,
        TOP,
        UP,
        DOWN;

    }
}

