/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.item;

import com.appframework.ActionList;
import com.appframework.ApplicationFrameActionList;
import com.appframework.mvc.GlobalCommand;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.item.AbstractGWItemAction;
import com.novell.gw.jclient.application.controls.itemedit.ComposeMode;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.frames.compose.FrameCompose;
import com.novell.gw.jclient.application.frames.compose.FrameComposeActionList;
import com.novell.gw.jclient.application.frames.compose.FrameComposeAppointment;
import com.novell.gw.jclient.application.frames.compose.FrameComposeMail;
import com.novell.gw.jclient.application.frames.compose.FrameComposePhone;
import com.novell.gw.jclient.application.frames.compose.FrameComposeReminderNote;
import com.novell.gw.jclient.application.frames.compose.FrameComposeTask;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.MailItem;
import com.novell.gw.jclient.bl.om.items.PhoneItem;
import com.novell.gw.jclient.bl.om.items.ReminderNote;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import com.novell.gw.jclient.bl.om.items.sendoptions.AppSendOptions;
import com.novell.gw.jclient.bl.om.items.sendoptions.ComposeItemSendOptions;
import com.novell.gw.jclient.bl.om.items.sendoptions.MailSendOptions;
import com.novell.gw.jclient.bl.om.items.sendoptions.NoteSendOptions;
import com.novell.gw.jclient.bl.om.items.sendoptions.TaskSendOptions;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class ActionResend
extends AbstractGWItemAction {
    private static Logger logger = Logger.getLogger(ActionResend.class);

    public ActionResend(ApplicationFrameActionList theAppActionList) {
        super((ActionList)theAppActionList, ActionKey.RESEND, StringResources.RESEND, ImageResources.ACT_RESEND);
        this.setToolTipText(StringResources.DESCRIPTION_RESEND);
    }

    protected void performAction(ActionEvent e) {
        try {
            ComposeItemSendOptions itemSendOptions;
            FrameCompose frameCompose;
            AbstractItem item = this.getItem();
            AbstractItem newItem = GWEngineUtils.composeResendItem(item, 0);
            if (newItem == null) {
                return;
            }
            if (newItem instanceof MailItem) {
                frameCompose = new FrameComposeMail(newItem, true, ComposeMode.RESEND, this.getUserGuid());
                itemSendOptions = new MailSendOptions(null);
            } else if (newItem instanceof AppointmentItem) {
                frameCompose = new FrameComposeAppointment(newItem, true, ComposeMode.RESEND, this.getUserGuid());
                itemSendOptions = new AppSendOptions(null);
            } else if (newItem instanceof TaskItem) {
                frameCompose = new FrameComposeTask(newItem, true, ComposeMode.RESEND, this.getUserGuid());
                itemSendOptions = new TaskSendOptions(null);
            } else if (newItem instanceof PhoneItem) {
                frameCompose = new FrameComposePhone(newItem, true, ComposeMode.RESEND, this.getUserGuid());
                itemSendOptions = new MailSendOptions(null);
            } else if (newItem instanceof ReminderNote) {
                frameCompose = new FrameComposeReminderNote(newItem, true, ComposeMode.RESEND, this.getUserGuid());
                itemSendOptions = new NoteSendOptions(null);
            } else {
                frameCompose = new FrameComposeReminderNote(newItem, true, ComposeMode.RESEND, this.getUserGuid());
                itemSendOptions = new NoteSendOptions(null);
            }
            newItem.getComposeItemSendOptions(itemSendOptions);
            frameCompose.getItemEdit().setSendOptions(itemSendOptions);
            frameCompose.showMe();
            GlobalCommand command = new GlobalCommand(480, frameCompose);
            ((FrameComposeActionList)frameCompose.getController()).processCommand(command);
        }
        catch (GWCommandException e1) {
            logger.error((Object)e1, (Throwable)e1);
            ErrorDialog.processGWException(e1, this.getActionList().getOwnerComponent());
        }
    }

    protected boolean checkEnableOnSelect() {
        return this.hasItems() && this.getItem().canResend();
    }

    public boolean showWithText() {
        return false;
    }
}

