/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls;

import com.appframework.utils.OS;
import com.novell.gw.jclient.application.options.OptionManager;
import java.awt.Frame;
import java.awt.Window;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookAndFeelManager {
    private static Logger logger = Logger.getLogger(LookAndFeelManager.class);
    public static final String GTK_LOOK_AND_FEEL_CLASS = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
    public static final String AQUA_LOOK_AND_FEEL_CLASS = "apple.laf.AquaLookAndFeel";
    private static boolean gtkLookAndFeel;
    private static boolean aquaLookAndFeel;
    private static String defaultLookAndFeelClassName;

    public static boolean isCurrentLookAndFeel(String lookAndFeelClassName) {
        String currentLookAndFeel = UIManager.getLookAndFeel().getClass().getName();
        logger.debug((Object)("currentLookAndFeel: " + currentLookAndFeel));
        return currentLookAndFeel.equals(lookAndFeelClassName);
    }

    public static void changeLookAndFeelOnTheFly(String lookAndFeelClassName) {
        try {
            Class.forName(lookAndFeelClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("class " + lookAndFeelClassName + " not found");
        }
        if (LookAndFeelManager.isCurrentLookAndFeel(lookAndFeelClassName)) {
            return;
        }
        logger.debug((Object)("changing look and feel to: " + lookAndFeelClassName));
        try {
            UIManager.setLookAndFeel(lookAndFeelClassName);
            LookAndFeelManager.handleLookAndFeelChange(lookAndFeelClassName);
            Collection<Window> windows = LookAndFeelManager.getAllWindows();
            logger.debug((Object)("found " + windows.size() + " windows"));
            for (Window window : windows) {
                if (window == null || !window.isVisible()) continue;
                try {
                    logger.debug((Object)("updating window: " + window));
                    SwingUtilities.updateComponentTreeUI(window);
                    window.pack();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    logger.debug((Object)e, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static Collection<Window> getAllWindows() {
        HashSet<Window> windows = new HashSet<Window>();
        windows.addAll(Arrays.asList(Frame.getFrames()));
        return windows;
    }

    private static void handleLookAndFeelChange(String lookAndFeelClassName) {
        gtkLookAndFeel = GTK_LOOK_AND_FEEL_CLASS.equals(lookAndFeelClassName);
        aquaLookAndFeel = AQUA_LOOK_AND_FEEL_CLASS.equals(lookAndFeelClassName);
    }

    public static boolean isGtkLookAndFeel() {
        return gtkLookAndFeel;
    }

    public static boolean isNimbusLookAndFeel() {
        return "Nimbus".equals(UIManager.getLookAndFeel().getName());
    }

    public static boolean isAquaLookAndFeel() {
        return aquaLookAndFeel;
    }

    public static String getDefaultLookAndFeelClassName() {
        return defaultLookAndFeelClassName;
    }

    static {
        if (OS.isGNOMESession() && OptionManager.getInstance().getInterfaceOptions().isGtkLookAndFeel()) {
            try {
                logger.debug((Object)"applying GTKLookAndFeel as initial look and feel");
                UIManager.setLookAndFeel(GTK_LOOK_AND_FEEL_CLASS);
            }
            catch (Exception e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        defaultLookAndFeelClassName = UIManager.getLookAndFeel().getClass().getName();
        LookAndFeelManager.handleLookAndFeelChange(defaultLookAndFeelClassName);
        logger.debug((Object)("defaultLookAndFeelClassName: " + defaultLookAndFeelClassName));
    }
}

