/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.List;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedComponentsFocusTraversalPolicy
extends FocusTraversalPolicy {
    private List<JComponent> components;

    public OrderedComponentsFocusTraversalPolicy(List<JComponent> components) {
        if (components == null) {
            throw new IllegalArgumentException("components is null");
        }
        if (components.isEmpty()) {
            throw new IllegalArgumentException("components is empty");
        }
        this.components = components;
    }

    @Override
    public Component getComponentAfter(Container aContainer, Component aComponent) {
        int index = this.components.indexOf(aComponent);
        if (index == -1 || index == this.components.size() - 1) {
            return this.getFirstComponent(aContainer);
        }
        return this.components.get(index + 1);
    }

    @Override
    public Component getComponentBefore(Container aContainer, Component aComponent) {
        int index = this.components.indexOf(aComponent);
        if (index == -1 || index == 0) {
            return this.getFirstComponent(aContainer);
        }
        return this.components.get(index - 1);
    }

    @Override
    public Component getDefaultComponent(Container aContainer) {
        return this.getFirstComponent(aContainer);
    }

    @Override
    public Component getFirstComponent(Container aContainer) {
        return this.components.get(0);
    }

    @Override
    public Component getLastComponent(Container aContainer) {
        return this.components.get(this.components.size() - 1);
    }
}

